/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import javax.persistence.Entity;
import javax.persistence.Id;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.test.bridge.CheckCustomFieldDefaultAnalyzer;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class CheckCustomFieldDefaultsTest
extends CheckCustomFieldDefaultAnalyzer {
    @Override
    protected Object entity(String id, String code, String result) {
        Experiment experiment = new Experiment();
        experiment.id = id;
        experiment.subject = code;
        experiment.result = result;
        return experiment;
    }

    @Override
    protected Class<?> getEntityType() {
        return Experiment.class;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Experiment.class};
    }

    @Entity
    @Indexed
    public static class Experiment {
        @Id
        @FieldBridge(impl=CheckCustomFieldDefaultAnalyzer.AdditionalFieldBridge.class)
        public String id;
        @Field(analyze=Analyze.NO)
        @FieldBridge(impl=CheckCustomFieldDefaultAnalyzer.AdditionalFieldBridge.class)
        public String subject;
        @Field(analyze=Analyze.YES)
        @FieldBridge(impl=CheckCustomFieldDefaultAnalyzer.AdditionalFieldBridge.class)
        @Analyzer(impl=WhitespaceAnalyzer.class)
        public String result;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.result == null ? 0 : this.result.hashCode());
            result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Experiment other = (Experiment)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.result == null ? other.result != null : !this.result.equals(other.result)) {
                return false;
            }
            return !(this.subject == null ? other.subject != null : !this.subject.equals(other.subject));
        }
    }
}

