/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.optimizations;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.engine.optimizations.SongWithLongTitle;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@TestForIssue(jiraKey="HSEARCH-1681")
@Category(value={SkipOnElasticsearch.class})
public class IndexReaderSeeOptimizedIndexTest
extends SearchTestBase {
    private String indexBasePath;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        try (Session session = this.openSession();){
            Transaction tx = session.beginTransaction();
            String band = "Impaled Northern Moonforest";
            SongWithLongTitle song1 = new SongWithLongTitle();
            song1.setId(1L);
            song1.setBand(band);
            song1.setTitle("Gazing At The Blasphemous Moon While Perched Atop A Very Very Very Very Very Very Very Forsaken Crest Of The Northern Mountain");
            SongWithLongTitle song2 = new SongWithLongTitle();
            song2.setId(2L);
            song2.setBand(band);
            song2.setTitle("Summoning The Unholy Frozen Winterdemons To The Grimmest And Most Frostbitten Inverted Forest Of Abazagorath");
            SongWithLongTitle song3 = new SongWithLongTitle();
            song3.setId(3L);
            song3.setBand(band);
            song3.setTitle("Awaiting The Frozen Blasphemy Of The Necroyeti's Lusting Necrobation Upon The Altar Of Voxrfszzzisnzf");
            session.persist((Object)song1);
            session.persist((Object)song2);
            session.persist((Object)song3);
            tx.commit();
        }
    }

    @After
    public void deleteAll() throws Exception {
        this.openSessionFactory();
        this.deleteEntities(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L));
        super.tearDown();
    }

    private void deleteEntities(Serializable ... ids) {
        try (Session session = this.openSession();){
            Transaction tx = session.beginTransaction();
            for (Serializable id : ids) {
                SongWithLongTitle entity = (SongWithLongTitle)session.get(SongWithLongTitle.class, id);
                if (entity == null) continue;
                session.delete((Object)entity);
            }
            tx.commit();
        }
    }

    public static long folderSize(File directory) {
        long length = 0L;
        for (File file : directory.listFiles()) {
            if (file.isFile()) {
                length += file.length();
                continue;
            }
            length += IndexReaderSeeOptimizedIndexTest.folderSize(file);
        }
        return length;
    }

    @Override
    public void configure(Map<String, Object> settings) {
        settings.put("hibernate.search.default.directory_provider", "filesystem");
        this.indexBasePath = (String)settings.get("hibernate.search.default.indexBase");
    }

    @Test
    public void testFolderSize() throws Exception {
        File indexFolder = new File(this.indexBasePath);
        long initialFolderSize = IndexReaderSeeOptimizedIndexTest.folderSize(indexFolder);
        try (Session session = this.openSession();){
            session.beginTransaction();
            SearchFactory searchFactory = Search.getFullTextSession((Session)session).getSearchFactory();
            searchFactory.optimize();
            session.getTransaction().commit();
        }
        long afterSessionClosed = IndexReaderSeeOptimizedIndexTest.folderSize(indexFolder);
        this.closeSessionFactory();
        long afterFactoryClosed = IndexReaderSeeOptimizedIndexTest.folderSize(indexFolder);
        Assertions.assertThat((long)afterSessionClosed).isEqualTo(afterFactoryClosed);
        Assertions.assertThat((long)afterFactoryClosed).isLessThan(initialFolderSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexReaderAccessOptimizedIndex() throws Exception {
        try (Session session = this.openSession();){
            session.beginTransaction();
            session.delete(session.load(SongWithLongTitle.class, (Serializable)Long.valueOf(1L)));
            session.getTransaction().commit();
            session.clear();
            session.beginTransaction();
            SearchFactory searchFactory = Search.getFullTextSession((Session)session).getSearchFactory();
            try (IndexReader indexReader = this.indexReader(searchFactory);){
                ((BooleanAssert)Assertions.assertThat((boolean)indexReader.hasDeletions()).as("IndexReader should see the deletions before the optimization")).isTrue();
                searchFactory.optimize();
                session.getTransaction().commit();
            }
            indexReader = this.indexReader(searchFactory);
            var5_7 = null;
            try {
                ((BooleanAssert)Assertions.assertThat((boolean)indexReader.hasDeletions()).as("IndexReader should see some deletions after optimization")).isFalse();
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (indexReader != null) {
                    if (var5_7 != null) {
                        try {
                            indexReader.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        indexReader.close();
                    }
                }
            }
        }
        finally {
            this.closeSessionFactory();
        }
    }

    private IndexReader indexReader(SearchFactory searchFactory) {
        return searchFactory.getIndexReaderAccessor().open(new Class[]{SongWithLongTitle.class});
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{SongWithLongTitle.class};
    }
}

