/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id.withmeta;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.test.id.withmeta.PersonPK;

public class PersonPKMetadataProviderBridge
implements MetadataProvidingFieldBridge,
TwoWayFieldBridge {
    public Object get(String name, Document document) {
        PersonPK id = new PersonPK();
        IndexableField field = document.getField(PersonPKMetadataProviderBridge.firstName(name));
        id.setFirstName(field.stringValue());
        field = document.getField(PersonPKMetadataProviderBridge.lastName(name));
        id.setLastName(field.stringValue());
        return id;
    }

    public String objectToString(Object object) {
        PersonPK id = (PersonPK)object;
        StringBuilder sb = new StringBuilder();
        sb.append(id.getFirstName()).append(" ").append(id.getLastName());
        return sb.toString();
    }

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        PersonPK id = (PersonPK)value;
        luceneOptions.addFieldToDocument(PersonPKMetadataProviderBridge.firstName(name), id.getFirstName(), document);
        luceneOptions.addFieldToDocument(PersonPKMetadataProviderBridge.lastName(name), id.getLastName(), document);
        luceneOptions.addFieldToDocument(name, this.objectToString(id), document);
    }

    public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
        builder.field(PersonPKMetadataProviderBridge.firstName(name), FieldType.STRING).field(PersonPKMetadataProviderBridge.lastName(name), FieldType.STRING);
    }

    private static String lastName(String name) {
        return name + "_lastName";
    }

    private static String firstName(String name) {
        return name + "_firstName";
    }
}

