/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.dsl;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.test.query.dsl.CoffeeBrand;

@Entity
@Indexed
public class Coffee {
    private Integer id;
    private String name;
    private String summary;
    private String description;
    private int intensity;
    private String internalDescription;
    private CoffeeBrand brand;

    @Id
    @GeneratedValue
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Field(termVector=TermVector.NO, store=Store.YES)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Field(termVector=TermVector.YES)
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Column(length=2000)
    @Field(termVector=TermVector.YES)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getIntensity() {
        return this.intensity;
    }

    public void setIntensity(int intensity) {
        this.intensity = intensity;
    }

    @Field
    public String getInternalDescription() {
        return this.internalDescription;
    }

    public void setInternalDescription(String internalDescription) {
        this.internalDescription = internalDescription;
    }

    @ManyToOne
    @IndexedEmbedded(includeEmbeddedObjectId=true)
    public CoffeeBrand getBrand() {
        return this.brand;
    }

    public void setBrand(CoffeeBrand brand) {
        this.brand = brand;
    }

    public String toString() {
        return "Coffee{id=" + this.id + ", name='" + this.name + '\'' + ", summary='" + this.summary + '\'' + ", description='" + this.description + '\'' + ", intensity=" + this.intensity + '}';
    }
}

