/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.test.query.facet.AbstractFacetTest;
import org.hibernate.search.test.query.facet.Car;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

public class StringFacetingTest
extends AbstractFacetTest {
    @Test
    @TestForIssue(jiraKey="HSEARCH-809")
    public void testStringFaceting() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("manufacturer").onField("make").discrete().includeZeroCounts(false).createFacetingRequest();
        FullTextQuery query = this.matchAll(request);
        List facetList = query.getFacetManager().getFacets("manufacturer");
        Assert.assertEquals((String)"Wrong number of facets", (long)5L, (long)facetList.size());
        this.assertFacet((Facet)facetList.get(0), "Honda", 13);
        this.assertFacet((Facet)facetList.get(1), "BMW", 12);
        this.assertFacet((Facet)facetList.get(2), "Mercedes", 12);
        this.assertFacet((Facet)facetList.get(3), "Toyota", 12);
        this.assertFacet((Facet)facetList.get(4), "Ford", 1);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2376")
    public void testStringFacetingWithNameCollision() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("manufacturer").onField("facetNameCollision").discrete().includeZeroCounts(false).createFacetingRequest();
        FullTextQuery query = this.matchAll(request);
        List facetList = query.getFacetManager().getFacets("manufacturer");
        Assert.assertEquals((String)"Wrong number of facets", (long)5L, (long)facetList.size());
        this.assertFacet((Facet)facetList.get(0), "Honda", 13);
        this.assertFacet((Facet)facetList.get(1), "BMW", 12);
        this.assertFacet((Facet)facetList.get(2), "Mercedes", 12);
        this.assertFacet((Facet)facetList.get(3), "Toyota", 12);
        this.assertFacet((Facet)facetList.get(4), "Ford", 1);
    }

    private void assertFacet(Facet facet, String expectedMake, int expectedCount) {
        Assert.assertEquals((String)"Wrong facet value", (Object)expectedMake, (Object)facet.getValue());
        Assert.assertEquals((String)"Wrong facet count", (long)expectedCount, (long)facet.getCount());
    }

    private FullTextQuery matchAll(FacetingRequest request) {
        MatchAllDocsQuery luceneQuery = new MatchAllDocsQuery();
        FullTextQuery query = this.fullTextSession.createFullTextQuery((Query)luceneQuery, new Class[]{Car.class});
        query.getFacetManager().enableFaceting(request);
        Assert.assertEquals((String)"Wrong number of indexed cars", (long)50L, (long)query.getResultSize());
        return query;
    }

    @Override
    public void loadTestData(Session session) {
        Transaction tx = session.beginTransaction();
        for (String make : makes) {
            for (String color : colors) {
                for (int cc : ccs) {
                    Car car = new Car(make, color, cc);
                    session.save((Object)car);
                }
            }
        }
        Car car = new Car("Honda", "yellow", 2407);
        session.save((Object)car);
        car = new Car("Ford", "yellow", 2500);
        session.save((Object)car);
        tx.commit();
        session.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Car.class};
    }
}

