/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.nullValues;

import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.ProjectionToMapResultTransformer;
import org.hibernate.search.test.query.nullValues.Value;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.transform.ResultTransformer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@TestForIssue(jiraKey="HSEARCH-115")
@Category(value={SkipOnElasticsearch.class})
public class IndexNullLuceneDocumentContentTest
extends SearchTestBase {
    @Test
    public void testLuceneDocumentContainsNullToken() throws Exception {
        Value nullValue = new Value(null);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        this.getSession().save((Object)nullValue);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        Document document = this.getSingleIndexedDocument(fullTextSession);
        String indexedNullString = document.get("value");
        String expectedString = "_custom_token_";
        Assert.assertEquals((String)("The null value should be indexed as " + expectedString), (Object)expectedString, (Object)indexedNullString);
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testConfiguredDefaultNullToken() throws Exception {
        Value nullValue = new Value(null);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        this.getSession().save((Object)nullValue);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        Document document = this.getSingleIndexedDocument(fullTextSession);
        String indexedNullString = document.get("fallback");
        String expectedString = "fubar";
        Assert.assertEquals((String)("The null value should be indexed as " + expectedString), (Object)expectedString, (Object)indexedNullString);
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testNullIndexingWithCustomFieldBridge() throws Exception {
        Value nullValue = new Value(null);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        this.getSession().save((Object)nullValue);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        Document document = this.getSingleIndexedDocument(fullTextSession);
        String indexedNullString = document.get("dummy");
        String expectedString = "_dummy_";
        Assert.assertEquals((String)("The null value should be indexed as " + expectedString), (Object)expectedString, (Object)indexedNullString);
        tx.commit();
        fullTextSession.close();
    }

    private Document getSingleIndexedDocument(FullTextSession fullTextSession) throws ParseException {
        Query query = this.createLuceneQuery();
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Value.class});
        fullTextQuery.setProjection(new String[]{"__HSearch_Document"});
        fullTextQuery.setResultTransformer((ResultTransformer)new ProjectionToMapResultTransformer());
        List mappedResults = fullTextQuery.list();
        Assert.assertTrue((String)"Wrong result size", (mappedResults.size() == 1 ? 1 : 0) != 0);
        Map map = (Map)mappedResults.get(0);
        Document document = (Document)map.get("__HSearch_Document");
        Assert.assertNotNull((Object)document);
        return document;
    }

    private Query createLuceneQuery() throws ParseException {
        QueryParser parser = new QueryParser("id", TestConstants.standardAnalyzer);
        parser.setAllowLeadingWildcard(true);
        return parser.parse("*");
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default_null_token", "fubar");
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Value.class};
    }
}

