/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.sorting;

import java.util.List;
import java.util.Map;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.sorting.BrickLayer;
import org.hibernate.search.test.query.sorting.Plumber;
import org.hibernate.search.test.query.sorting.Thatcher;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class SortWithIndexUninvertingTest
extends SearchTestBase {
    private static FullTextSession fullTextSession;
    private static QueryParser queryParser;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        fullTextSession = Search.getFullTextSession((Session)this.openSession());
        queryParser = new QueryParser("title", TestConstants.stopAnalyzer);
        this.createTestContractors();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (fullTextSession.getTransaction().getStatus() != TransactionStatus.ACTIVE) {
            this.deleteTestContractors();
            fullTextSession.close();
        }
        super.tearDown();
    }

    @Test
    public void testCombinedQueryOnIndexWithSortFieldAndIndexToBeUninverted() throws Exception {
        Transaction tx = fullTextSession.beginTransaction();
        Query query = queryParser.parse("name:Bill");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Plumber.class, BrickLayer.class});
        Sort sort = new Sort(new SortField("sortName", SortField.Type.STRING));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        ((ListAssert)Assertions.assertThat((List)result).onProperty("name").describedAs("Expecting results from index with sort field and uninverted index in the correct sort order")).containsExactly(new Object[]{"Bill the brick layer", "Bill the plumber"});
        tx.commit();
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void testQueryOnIndexSharedByEntityWithRequiredSortFieldAndEntityWithoutRaisesException() throws Exception {
        Transaction tx = fullTextSession.beginTransaction();
        Query query = queryParser.parse("name:Bill");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Thatcher.class, BrickLayer.class});
        Sort sort = new Sort(new SortField("sortName", SortField.Type.STRING));
        hibQuery.setSort(sort);
        try {
            hibQuery.list();
            Assert.fail((String)"Expected exception was not raised");
        }
        catch (Exception e) {
            Assertions.assertThat((String)e.getMessage()).contains("HSEARCH000298");
        }
        tx.commit();
    }

    private void createTestContractors() {
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.save((Object)new Plumber(1, "Bill the plumber"));
        fullTextSession.save((Object)new BrickLayer(2, "Bill the brick layer", "Johnson"));
        fullTextSession.save((Object)new BrickLayer(4, "Barny the brick layer", "Johnson"));
        fullTextSession.save((Object)new BrickLayer(5, "Bart the brick layer", "Higgins"));
        fullTextSession.save((Object)new BrickLayer(6, "Barny the brick layer", "Higgins"));
        fullTextSession.save((Object)new Thatcher(3, "Bill the thatcher"));
        tx.commit();
        fullTextSession.clear();
    }

    private void deleteTestContractors() {
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.createQuery("delete " + Plumber.class.getName()).executeUpdate();
        fullTextSession.createQuery("delete " + BrickLayer.class.getName()).executeUpdate();
        fullTextSession.createQuery("delete " + Thatcher.class.getName()).executeUpdate();
        tx.commit();
        fullTextSession.clear();
    }

    @Override
    public void configure(Map<String, Object> settings) {
        settings.put("hibernate.search.index_uninverting_allowed", "true");
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Plumber.class, BrickLayer.class, Thatcher.class};
    }
}

