/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.stub;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import org.webbitserver.EventSourceConnection;
import org.webbitserver.EventSourceMessage;
import org.webbitserver.HttpRequest;
import org.webbitserver.WebSocketConnection;
import org.webbitserver.stub.StubDataHolder;
import org.webbitserver.stub.StubHttpRequest;

public class StubConnection
extends StubDataHolder
implements EventSourceConnection,
WebSocketConnection {
    private final List<String> sentMessages = new LinkedList<String>();
    private final List<byte[]> sentBinaryMessages = new LinkedList<byte[]>();
    private final List<byte[]> sentPings = new LinkedList<byte[]>();
    private final List<byte[]> sentPongs = new LinkedList<byte[]>();
    private boolean closed = false;
    private HttpRequest httpRequest;
    private String version = null;

    public StubConnection(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public StubConnection() {
        this(new StubHttpRequest());
    }

    @Override
    public HttpRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public StubConnection send(EventSourceMessage message) {
        return this.send(message.build());
    }

    public StubConnection httpRequest(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    @Override
    public StubConnection send(String message) {
        this.sentMessages.add(message);
        return this;
    }

    @Override
    public StubConnection send(byte[] message) {
        return this.send(message, 0, message.length);
    }

    @Override
    public StubConnection send(byte[] message, int offset, int length) {
        byte[] subMessage = new byte[length];
        System.arraycopy(message, offset, subMessage, 0, length);
        this.sentBinaryMessages.add(subMessage);
        return this;
    }

    @Override
    public StubConnection ping(byte[] message) {
        this.sentPings.add(message);
        return this;
    }

    @Override
    public StubConnection pong(byte[] message) {
        this.sentPongs.add(message);
        return this;
    }

    @Override
    public StubConnection close() {
        this.closed = true;
        return this;
    }

    public boolean closed() {
        return this.closed;
    }

    public List<String> sentMessages() {
        return this.sentMessages;
    }

    public List<byte[]> sentBinaryMessages() {
        return this.sentBinaryMessages;
    }

    public List<byte[]> sentPings() {
        return this.sentPings;
    }

    public List<byte[]> sentPongs() {
        return this.sentPongs;
    }

    @Override
    public StubConnection data(String key, Object value) {
        super.data(key, value);
        return this;
    }

    @Override
    public Executor handlerExecutor() {
        return this;
    }

    @Override
    public String version() {
        return this.version;
    }

    public StubConnection version(String version) {
        this.version = version;
        return this;
    }

    @Override
    public void execute(Runnable command) {
        command.run();
    }
}

