/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import retrofit.ErrorHandler;
import retrofit.RequestInterceptor;
import retrofit.RequestInterceptorTape;
import retrofit.ResponseWrapper;
import retrofit.RetrofitError;
import rx.Observable;
import rx.Subscriber;
import rx.subscriptions.Subscriptions;

final class RxSupport {
    private final Executor executor;
    private final ErrorHandler errorHandler;
    private final RequestInterceptor requestInterceptor;

    RxSupport(Executor executor, ErrorHandler errorHandler, RequestInterceptor requestInterceptor) {
        this.executor = executor;
        this.errorHandler = errorHandler;
        this.requestInterceptor = requestInterceptor;
    }

    Observable createRequestObservable(final Invoker invoker) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Object>(){

            public void call(Subscriber<? super Object> subscriber) {
                RequestInterceptorTape interceptorTape = new RequestInterceptorTape();
                RxSupport.this.requestInterceptor.intercept(interceptorTape);
                Runnable runnable = RxSupport.this.getRunnable((Subscriber<? super Object>)subscriber, invoker, interceptorTape);
                FutureTask<Object> task = new FutureTask<Object>(runnable, null);
                subscriber.add(Subscriptions.from(task));
                RxSupport.this.executor.execute(task);
            }
        });
    }

    private Runnable getRunnable(final Subscriber<? super Object> subscriber, final Invoker invoker, final RequestInterceptorTape interceptorTape) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (subscriber.isUnsubscribed()) {
                        return;
                    }
                    ResponseWrapper wrapper = invoker.invoke(interceptorTape);
                    subscriber.onNext(wrapper.responseBody);
                    subscriber.onCompleted();
                }
                catch (RetrofitError e) {
                    subscriber.onError(RxSupport.this.errorHandler.handleError(e));
                }
            }
        };
    }

    static interface Invoker {
        public ResponseWrapper invoke(RequestInterceptor var1);
    }
}

