/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONObject;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Shape;
import org.springframework.data.mongodb.InvalidMongoDbApiUsageException;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.Sphere;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.GeoCommand;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class Criteria
implements CriteriaDefinition {
    private static final Object NOT_SET = new Object();
    private String key;
    private List<Criteria> criteriaChain;
    private LinkedHashMap<String, Object> criteria = new LinkedHashMap();
    private Object isValue = NOT_SET;

    public Criteria() {
        this.criteriaChain = new ArrayList<Criteria>();
    }

    public Criteria(String key) {
        this.criteriaChain = new ArrayList<Criteria>();
        this.criteriaChain.add(this);
        this.key = key;
    }

    protected Criteria(List<Criteria> criteriaChain, String key) {
        this.criteriaChain = criteriaChain;
        this.criteriaChain.add(this);
        this.key = key;
    }

    public static Criteria where(String key) {
        return new Criteria(key);
    }

    public Criteria and(String key) {
        return new Criteria(this.criteriaChain, key);
    }

    public Criteria is(Object o) {
        if (!this.isValue.equals(NOT_SET)) {
            throw new InvalidMongoDbApiUsageException("Multiple 'is' values declared. You need to use 'and' with multiple criteria");
        }
        if (this.lastOperatorWasNot()) {
            throw new InvalidMongoDbApiUsageException("Invalid query: 'not' can't be used with 'is' - use 'ne' instead.");
        }
        this.isValue = o;
        return this;
    }

    private boolean lastOperatorWasNot() {
        return this.criteria.size() > 0 && "$not".equals(this.criteria.keySet().toArray()[this.criteria.size() - 1]);
    }

    public Criteria ne(Object o) {
        this.criteria.put("$ne", o);
        return this;
    }

    public Criteria lt(Object o) {
        this.criteria.put("$lt", o);
        return this;
    }

    public Criteria lte(Object o) {
        this.criteria.put("$lte", o);
        return this;
    }

    public Criteria gt(Object o) {
        this.criteria.put("$gt", o);
        return this;
    }

    public Criteria gte(Object o) {
        this.criteria.put("$gte", o);
        return this;
    }

    public Criteria in(Object ... o) {
        if (o.length > 1 && o[1] instanceof Collection) {
            throw new InvalidMongoDbApiUsageException("You can only pass in one argument of type " + o[1].getClass().getName());
        }
        this.criteria.put("$in", Arrays.asList(o));
        return this;
    }

    public Criteria in(Collection<?> c) {
        this.criteria.put("$in", c);
        return this;
    }

    public Criteria nin(Object ... o) {
        return this.nin(Arrays.asList(o));
    }

    public Criteria nin(Collection<?> o) {
        this.criteria.put("$nin", o);
        return this;
    }

    public Criteria mod(Number value, Number remainder) {
        ArrayList<Number> l = new ArrayList<Number>();
        l.add(value);
        l.add(remainder);
        this.criteria.put("$mod", l);
        return this;
    }

    public Criteria all(Object ... o) {
        return this.all(Arrays.asList(o));
    }

    public Criteria all(Collection<?> o) {
        this.criteria.put("$all", o);
        return this;
    }

    public Criteria size(int s) {
        this.criteria.put("$size", s);
        return this;
    }

    public Criteria exists(boolean b) {
        this.criteria.put("$exists", b);
        return this;
    }

    public Criteria type(int t) {
        this.criteria.put("$type", t);
        return this;
    }

    public Criteria not() {
        return this.not(null);
    }

    private Criteria not(Object value) {
        this.criteria.put("$not", value);
        return this;
    }

    public Criteria regex(String re) {
        return this.regex(re, null);
    }

    public Criteria regex(String re, String options) {
        return this.regex(this.toPattern(re, options));
    }

    public Criteria regex(Pattern pattern) {
        Assert.notNull((Object)pattern);
        if (this.lastOperatorWasNot()) {
            return this.not(pattern);
        }
        this.isValue = pattern;
        return this;
    }

    private Pattern toPattern(String regex, String options) {
        Assert.notNull((Object)regex);
        return Pattern.compile(regex, options == null ? 0 : BSON.regexFlags((String)options));
    }

    public Criteria withinSphere(Circle circle) {
        Assert.notNull((Object)circle);
        this.criteria.put("$geoWithin", new GeoCommand(new Sphere(circle)));
        return this;
    }

    public Criteria within(Shape shape) {
        Assert.notNull((Object)shape);
        this.criteria.put("$geoWithin", new GeoCommand(shape));
        return this;
    }

    public Criteria near(Point point) {
        Assert.notNull((Object)point);
        this.criteria.put("$near", point);
        return this;
    }

    public Criteria nearSphere(Point point) {
        Assert.notNull((Object)point);
        this.criteria.put("$nearSphere", point);
        return this;
    }

    public Criteria intersects(GeoJson geoJson) {
        Assert.notNull((Object)geoJson, (String)"GeoJson must not be null!");
        this.criteria.put("$geoIntersects", geoJson);
        return this;
    }

    public Criteria maxDistance(double maxDistance) {
        if (this.createNearCriteriaForCommand("$near", "$maxDistance", maxDistance) || this.createNearCriteriaForCommand("$nearSphere", "$maxDistance", maxDistance)) {
            return this;
        }
        this.criteria.put("$maxDistance", maxDistance);
        return this;
    }

    public Criteria minDistance(double minDistance) {
        if (this.createNearCriteriaForCommand("$near", "$minDistance", minDistance) || this.createNearCriteriaForCommand("$nearSphere", "$minDistance", minDistance)) {
            return this;
        }
        this.criteria.put("$minDistance", minDistance);
        return this;
    }

    public Criteria elemMatch(Criteria c) {
        this.criteria.put("$elemMatch", c.getCriteriaObject());
        return this;
    }

    public Criteria orOperator(Criteria ... criteria) {
        BasicDBList bsonList = this.createCriteriaList(criteria);
        return this.registerCriteriaChainElement(new Criteria("$or").is(bsonList));
    }

    public Criteria norOperator(Criteria ... criteria) {
        BasicDBList bsonList = this.createCriteriaList(criteria);
        return this.registerCriteriaChainElement(new Criteria("$nor").is(bsonList));
    }

    public Criteria andOperator(Criteria ... criteria) {
        BasicDBList bsonList = this.createCriteriaList(criteria);
        return this.registerCriteriaChainElement(new Criteria("$and").is(bsonList));
    }

    private Criteria registerCriteriaChainElement(Criteria criteria) {
        if (this.lastOperatorWasNot()) {
            throw new IllegalArgumentException("operator $not is not allowed around criteria chain element: " + criteria.getCriteriaObject());
        }
        this.criteriaChain.add(criteria);
        return this;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public DBObject getCriteriaObject() {
        if (this.criteriaChain.size() == 1) {
            return this.criteriaChain.get(0).getSingleCriteriaObject();
        }
        if (CollectionUtils.isEmpty(this.criteriaChain) && !CollectionUtils.isEmpty(this.criteria)) {
            return this.getSingleCriteriaObject();
        }
        BasicDBObject criteriaObject = new BasicDBObject();
        for (Criteria c : this.criteriaChain) {
            DBObject dbo = c.getSingleCriteriaObject();
            for (String k : dbo.keySet()) {
                this.setValue((DBObject)criteriaObject, k, dbo.get(k));
            }
        }
        return criteriaObject;
    }

    protected DBObject getSingleCriteriaObject() {
        BasicDBObject dbo = new BasicDBObject();
        boolean not = false;
        for (String k : this.criteria.keySet()) {
            Object value = this.criteria.get(k);
            if (Criteria.requiresGeoJsonFormat(value)) {
                value = new BasicDBObject("$geometry", value);
            }
            if (not) {
                BasicDBObject notDbo = new BasicDBObject();
                notDbo.put(k, value);
                dbo.put("$not", (Object)notDbo);
                not = false;
                continue;
            }
            if ("$not".equals(k) && value == null) {
                not = true;
                continue;
            }
            dbo.put(k, value);
        }
        if (!StringUtils.hasText((String)this.key)) {
            if (not) {
                return new BasicDBObject("$not", (Object)dbo);
            }
            return dbo;
        }
        BasicDBObject queryCriteria = new BasicDBObject();
        if (!NOT_SET.equals(this.isValue)) {
            queryCriteria.put(this.key, this.isValue);
            queryCriteria.putAll((BSONObject)dbo);
        } else {
            queryCriteria.put(this.key, (Object)dbo);
        }
        return queryCriteria;
    }

    private BasicDBList createCriteriaList(Criteria[] criteria) {
        BasicDBList bsonList = new BasicDBList();
        for (Criteria c : criteria) {
            bsonList.add((Object)c.getCriteriaObject());
        }
        return bsonList;
    }

    private void setValue(DBObject dbo, String key, Object value) {
        Object existing = dbo.get(key);
        if (existing != null) {
            throw new InvalidMongoDbApiUsageException("Due to limitations of the com.mongodb.BasicDBObject, you can't add a second '" + key + "' expression specified as '" + key + " : " + value + "'. " + "Criteria already contains '" + key + " : " + existing + "'.");
        }
        dbo.put(key, value);
    }

    private boolean createNearCriteriaForCommand(String command, String operation, double maxDistance) {
        if (!this.criteria.containsKey(command)) {
            return false;
        }
        Object existingNearOperationValue = this.criteria.get(command);
        if (existingNearOperationValue instanceof DBObject) {
            ((DBObject)existingNearOperationValue).put(operation, (Object)maxDistance);
            return true;
        }
        if (existingNearOperationValue instanceof GeoJson) {
            BasicDBObject dbo = new BasicDBObject("$geometry", existingNearOperationValue).append(operation, (Object)maxDistance);
            this.criteria.put(command, dbo);
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Criteria that = (Criteria)obj;
        if (this.criteriaChain.size() != that.criteriaChain.size()) {
            return false;
        }
        for (int i = 0; i < this.criteriaChain.size(); ++i) {
            Criteria right;
            Criteria left = this.criteriaChain.get(i);
            if (this.simpleCriteriaEquals(left, right = that.criteriaChain.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean simpleCriteriaEquals(Criteria left, Criteria right) {
        boolean keyEqual = left.key == null ? right.key == null : left.key.equals(right.key);
        boolean criteriaEqual = left.criteria.equals(right.criteria);
        boolean valueEqual = this.isEqual(left.isValue, right.isValue);
        return keyEqual && criteriaEqual && valueEqual;
    }

    private boolean isEqual(Object left, Object right) {
        if (left == null) {
            return right == null;
        }
        if (left instanceof Pattern) {
            return right instanceof Pattern ? ((Pattern)left).pattern().equals(((Pattern)right).pattern()) : false;
        }
        return ObjectUtils.nullSafeEquals((Object)left, (Object)right);
    }

    public int hashCode() {
        int result = 17;
        result += ObjectUtils.nullSafeHashCode((Object)this.key);
        result += this.criteria.hashCode();
        return result += ObjectUtils.nullSafeHashCode((Object)this.isValue);
    }

    private static boolean requiresGeoJsonFormat(Object value) {
        return value instanceof GeoJson || value instanceof GeoCommand && ((GeoCommand)value).getShape() instanceof GeoJson;
    }
}

