/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class IfController
extends GenericController
implements Serializable {
    private static final Logger logger = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private static final String CONDITION = "IfController.condition";
    private static final String EVALUATE_ALL = "IfController.evaluateAll";
    private static final String USE_EXPRESSION = "IfController.useExpression";

    public IfController() {
    }

    public IfController(String condition) {
        this.setCondition(condition);
    }

    public void setCondition(String condition) {
        this.setProperty(new StringProperty(CONDITION, condition));
    }

    public String getCondition() {
        return this.getPropertyAsString(CONDITION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluateCondition(String cond) {
        logger.debug("    getCondition() : [" + cond + "]");
        String resultStr = "";
        boolean result = false;
        Context cx = Context.enter();
        try {
            Scriptable scope = cx.initStandardObjects(null);
            Object cxResultObject = cx.evaluateString(scope, cond, "<cmd>", 1, null);
            resultStr = Context.toString((Object)cxResultObject);
            if (resultStr.equals("false")) {
                result = false;
            } else if (resultStr.equals("true")) {
                result = true;
            } else {
                throw new Exception(" BAD CONDITION :: " + cond + " :: expected true or false");
            }
            logger.debug("    >> evaluate Condition -  [ " + cond + "] results is  [" + result + "]");
        }
        catch (Exception e) {
            logger.error(this.getName() + ": error while processing " + "[" + cond + "]\n", (Throwable)e);
        }
        finally {
            Context.exit();
        }
        return result;
    }

    private static boolean evaluateExpression(String cond) {
        return cond.equalsIgnoreCase("true");
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public Sampler next() {
        boolean result = true;
        if (this.isEvaluateAll() || this.isFirst()) {
            boolean bl = result = this.isUseExpression() ? IfController.evaluateExpression(this.getCondition()) : this.evaluateCondition(this.getCondition());
        }
        if (result) {
            return super.next();
        }
        try {
            this.reInitializeSubController();
            return this.nextIsNull();
        }
        catch (NextIsNullException e1) {
            return null;
        }
    }

    @Override
    public void triggerEndOfLoop() {
        this.reInitializeSubController();
        super.triggerEndOfLoop();
    }

    public boolean isEvaluateAll() {
        return this.getPropertyAsBoolean(EVALUATE_ALL, false);
    }

    public void setEvaluateAll(boolean b) {
        this.setProperty(EVALUATE_ALL, b);
    }

    public boolean isUseExpression() {
        return this.getPropertyAsBoolean(USE_EXPRESSION, false);
    }

    public void setUseExpression(boolean selected) {
        this.setProperty(USE_EXPRESSION, selected, false);
    }
}

