/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jmeter.samplers.AbstractSampleSender;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class BatchSampleSender
extends AbstractSampleSender
implements Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private static final int DEFAULT_NUM_SAMPLE_THRESHOLD = 100;
    private static final long DEFAULT_TIME_THRESHOLD = 60000L;
    private static final int NUM_SAMPLES_THRESHOLD = JMeterUtils.getPropDefault("num_sample_threshold", 100);
    private static final long TIME_THRESHOLD_MS = JMeterUtils.getPropDefault("time_threshold", 60000L);
    private final int clientConfiguredNumSamplesThreshold = JMeterUtils.getPropDefault("num_sample_threshold", 100);
    private final long clientConfiguredTimeThresholdMs = JMeterUtils.getPropDefault("time_threshold", 60000L);
    private final RemoteSampleListener listener;
    private final List<SampleEvent> sampleStore = new ArrayList<SampleEvent>();
    private transient long batchSendTime = -1L;
    private volatile transient int numSamplesThreshold;
    private volatile transient long timeThresholdMs;

    @Deprecated
    public BatchSampleSender() {
        this(null);
        log.warn("Constructor only intended for use in testing");
    }

    protected BatchSampleSender(RemoteSampleListener listener) {
        this.listener = listener;
        if (this.isClientConfigured()) {
            log.info("Using batching (client settings) for this run. Thresholds: num=" + this.clientConfiguredNumSamplesThreshold + ", time=" + this.clientConfiguredTimeThresholdMs);
        } else {
            log.info("Using batching (server settings) for this run.");
        }
    }

    protected RemoteSampleListener getListener() {
        return this.listener;
    }

    protected List<SampleEvent> getSampleStore() {
        return this.sampleStore;
    }

    @Override
    public void testEnded(String host) {
        log.info("Test Ended on " + host);
        try {
            if (this.sampleStore.size() != 0) {
                this.listener.processBatch(this.sampleStore);
                this.sampleStore.clear();
            }
            this.listener.testEnded(host);
        }
        catch (RemoteException err) {
            log.error("testEnded(host)", (Throwable)err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sampleOccurred(SampleEvent e) {
        List<SampleEvent> list = this.sampleStore;
        synchronized (list) {
            this.sampleStore.add(e);
            int sampleCount = this.sampleStore.size();
            boolean sendNow = false;
            if (this.numSamplesThreshold != -1 && sampleCount >= this.numSamplesThreshold) {
                sendNow = true;
            }
            long now = 0L;
            if (this.timeThresholdMs != -1L) {
                now = System.currentTimeMillis();
                if (this.batchSendTime == -1L) {
                    this.batchSendTime = now + this.timeThresholdMs;
                }
                if (this.batchSendTime < now && sampleCount > 0) {
                    sendNow = true;
                }
            }
            if (sendNow) {
                try {
                    log.debug("Firing sample");
                    this.listener.processBatch(this.sampleStore);
                    this.sampleStore.clear();
                    if (this.timeThresholdMs != -1L) {
                        this.batchSendTime = now + this.timeThresholdMs;
                    }
                }
                catch (RemoteException err) {
                    log.error("sampleOccurred", (Throwable)err);
                }
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.isClientConfigured()) {
            this.numSamplesThreshold = this.clientConfiguredNumSamplesThreshold;
            this.timeThresholdMs = this.clientConfiguredTimeThresholdMs;
        } else {
            this.numSamplesThreshold = NUM_SAMPLES_THRESHOLD;
            this.timeThresholdMs = TIME_THRESHOLD_MS;
        }
        log.info("Using batching for this run. Thresholds: num=" + this.numSamplesThreshold + ", time=" + this.timeThresholdMs);
        return this;
    }
}

