/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import org.apache.jmeter.gui.AbstractJMeterGuiComponent;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.util.JMeterUtils;

public abstract class AbstractThreadGroupGui
extends AbstractJMeterGuiComponent {
    private static final long serialVersionUID = 240L;
    private JRadioButton continueBox;
    private JRadioButton startNextLoop;
    private JRadioButton stopThrdBox;
    private JRadioButton stopTestBox;
    private JRadioButton stopTestNowBox;

    public AbstractThreadGroupGui() {
        this.init();
        this.initGui();
    }

    @Override
    public Collection<String> getMenuCategories() {
        return Arrays.asList("menu_threads");
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        pop.add(MenuFactory.makeMenus(new String[]{"menu_logic_controller", "menu_config_element", "menu_timer", "menu_pre_processors", "menu_generative_controller", "menu_post_processors", "menu_assertions", "menu_listener"}, JMeterUtils.getResString("add"), "Add"));
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.initGui();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createOnErrorPanel());
        this.add((Component)box, "North");
    }

    private void initGui() {
        this.continueBox.setSelected(true);
    }

    private JPanel createOnErrorPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("sampler_on_error_action")));
        ButtonGroup group = new ButtonGroup();
        this.continueBox = new JRadioButton(JMeterUtils.getResString("sampler_on_error_continue"));
        group.add(this.continueBox);
        panel.add(this.continueBox);
        this.startNextLoop = new JRadioButton(JMeterUtils.getResString("sampler_on_error_start_next_loop"));
        group.add(this.startNextLoop);
        panel.add(this.startNextLoop);
        this.stopThrdBox = new JRadioButton(JMeterUtils.getResString("sampler_on_error_stop_thread"));
        group.add(this.stopThrdBox);
        panel.add(this.stopThrdBox);
        this.stopTestBox = new JRadioButton(JMeterUtils.getResString("sampler_on_error_stop_test"));
        group.add(this.stopTestBox);
        panel.add(this.stopTestBox);
        this.stopTestNowBox = new JRadioButton(JMeterUtils.getResString("sampler_on_error_stop_test_now"));
        group.add(this.stopTestNowBox);
        panel.add(this.stopTestNowBox);
        return panel;
    }

    private void setSampleErrorBoxes(AbstractThreadGroup te) {
        if (te.getOnErrorStopTest()) {
            this.stopTestBox.setSelected(true);
        } else if (te.getOnErrorStopTestNow()) {
            this.stopTestNowBox.setSelected(true);
        } else if (te.getOnErrorStopThread()) {
            this.stopThrdBox.setSelected(true);
        } else if (te.getOnErrorStartNextLoop()) {
            this.startNextLoop.setSelected(true);
        } else {
            this.continueBox.setSelected(true);
        }
    }

    private String onSampleError() {
        if (this.stopTestBox.isSelected()) {
            return "stoptest";
        }
        if (this.stopTestNowBox.isSelected()) {
            return "stoptestnow";
        }
        if (this.stopThrdBox.isSelected()) {
            return "stopthread";
        }
        if (this.startNextLoop.isSelected()) {
            return "startnextloop";
        }
        return "continue";
    }

    @Override
    public void configure(TestElement tg) {
        super.configure(tg);
        this.setSampleErrorBoxes((AbstractThreadGroup)tg);
    }

    @Override
    protected void configureTestElement(TestElement tg) {
        super.configureTestElement(tg);
        tg.setProperty(new StringProperty("ThreadGroup.on_sample_error", this.onSampleError()));
    }
}

