/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.jmeter.gui.tree.JMeterTreeNode;

public class JMeterTreeNodeTransferable
implements Transferable {
    public static final DataFlavor JMETER_TREE_NODE_ARRAY_DATA_FLAVOR = new DataFlavor(JMeterTreeNode[].class, JMeterTreeNode[].class.getName());
    private static final DataFlavor[] DATA_FLAVORS = new DataFlavor[]{JMETER_TREE_NODE_ARRAY_DATA_FLAVOR};
    private byte[] data = null;

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return DATA_FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.match(JMETER_TREE_NODE_ARRAY_DATA_FLAVOR);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        if (this.data != null) {
            ObjectInput ois = null;
            try {
                JMeterTreeNode[] nodes;
                ois = new ObjectInputStream(new ByteArrayInputStream(this.data));
                JMeterTreeNode[] jMeterTreeNodeArray = nodes = (JMeterTreeNode[])ois.readObject();
                return jMeterTreeNodeArray;
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException("Failed to read object stream.", cnfe);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransferData(JMeterTreeNode[] nodes) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bos);
            oos.writeObject(nodes);
            this.data = bos.toByteArray();
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

