/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator;

import com.github.zafarkhaja.semver.Parser;
import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.expr.And;
import com.github.zafarkhaja.semver.expr.Equal;
import com.github.zafarkhaja.semver.expr.Expression;
import com.github.zafarkhaja.semver.expr.ExpressionParser;
import com.github.zafarkhaja.semver.expr.Greater;
import com.github.zafarkhaja.semver.expr.GreaterOrEqual;
import com.github.zafarkhaja.semver.expr.Less;
import com.github.zafarkhaja.semver.expr.LessOrEqual;
import com.github.zafarkhaja.semver.expr.Or;
import org.kurento.modulecreator.KurentoModuleCreatorException;

public class VersionManager {
    private static final String DEV_SUFFIX = "-dev";
    private static final int DEV_SUFFIX_LENGTH = "-dev".length();

    public static String convertToMavenImport(String version) {
        if (VersionManager.isDevelopmentVersion(version)) {
            return VersionManager.removeDevSuffix(version) + "-SNAPSHOT";
        }
        Expression expression = VersionManager.parseVersion(version);
        String mavenVersion = VersionManager.convertToMavenExpression(expression);
        if (mavenVersion == null) {
            throw new KurentoModuleCreatorException("Version '" + version + "' in import not supported");
        }
        return mavenVersion;
    }

    private static String convertToMavenExpression(Expression expression) {
        if (expression instanceof Equal) {
            return ((Equal)expression).getParsedVersion().toString();
        }
        if (expression instanceof Less) {
            return "(," + ((Less)expression).getParsedVersion() + "-SNAPSHOT)";
        }
        if (expression instanceof LessOrEqual) {
            return "(," + ((LessOrEqual)expression).getParsedVersion() + "]";
        }
        if (expression instanceof Greater) {
            return "(" + ((Greater)expression).getParsedVersion() + ",)";
        }
        if (expression instanceof GreaterOrEqual) {
            return "[" + ((GreaterOrEqual)expression).getParsedVersion() + ",)";
        }
        if (expression instanceof And) {
            String postFix;
            And and = (And)expression;
            Expression left = and.getLeft();
            Expression right = and.getRight();
            Expression greater = VersionManager.getGreater(left, right);
            Expression less = VersionManager.getLess(left, right);
            if (greater == null || less == null) {
                return null;
            }
            StringBuilder mavenVersion = new StringBuilder();
            Version greaterVersion = null;
            if (greater instanceof Greater) {
                mavenVersion.append("(");
                greaterVersion = ((Greater)greater).getParsedVersion();
            } else {
                mavenVersion.append("[");
                greaterVersion = ((GreaterOrEqual)greater).getParsedVersion();
            }
            mavenVersion.append(greaterVersion).append(",");
            Version lessVersion = null;
            if (less instanceof Less) {
                postFix = "-SNAPSHOT)";
                lessVersion = ((Less)less).getParsedVersion();
            } else {
                postFix = "]";
                lessVersion = ((LessOrEqual)less).getParsedVersion();
            }
            mavenVersion.append(lessVersion);
            mavenVersion.append(postFix);
            return mavenVersion.toString();
        }
        if (expression instanceof Or) {
            String left = VersionManager.convertToMavenExpression(((Or)expression).getLeft());
            String right = VersionManager.convertToMavenExpression(((Or)expression).getRight());
            if (left != null && right != null) {
                return left + "," + right;
            }
        }
        return null;
    }

    private static Expression getLess(Expression left, Expression right) {
        if (left instanceof Less || left instanceof LessOrEqual) {
            return left;
        }
        if (right instanceof Less || right instanceof LessOrEqual) {
            return right;
        }
        return null;
    }

    private static Expression getGreater(Expression left, Expression right) {
        if (left instanceof Greater || left instanceof GreaterOrEqual) {
            return left;
        }
        if (right instanceof Greater || right instanceof GreaterOrEqual) {
            return right;
        }
        return null;
    }

    public static String convertToNpmImport(String gitRepo, String version) {
        Expression expression;
        String npmVersion;
        if (VersionManager.isDevelopmentVersion(version)) {
            if (gitRepo == null) {
                version = VersionManager.removeDevSuffix(version);
            } else {
                version = gitRepo;
                return version;
            }
        }
        if ((npmVersion = VersionManager.convertToNpmExpression(expression = VersionManager.parseVersion(version))) == null) {
            throw new KurentoModuleCreatorException("Version '" + version + "' in import not supported");
        }
        return npmVersion;
    }

    private static Expression parseVersion(String version) {
        Parser<Expression> parser = ExpressionParser.newInstance();
        Expression expression = parser.parse(VersionManager.processCaretRanges(version));
        return expression;
    }

    private static String processCaretRanges(String version) {
        if (version.startsWith("^")) {
            String plainVersion = version.substring(1);
            return ">=" + plainVersion + " & <" + (Version.valueOf(plainVersion).getMajorVersion() + 1) + ".0.0";
        }
        return version;
    }

    private static String convertToNpmExpression(Expression expression) {
        if (expression instanceof Equal) {
            return ((Equal)expression).getParsedVersion().toString();
        }
        if (expression instanceof Less) {
            return "<" + ((Less)expression).getParsedVersion();
        }
        if (expression instanceof LessOrEqual) {
            return "<=" + ((LessOrEqual)expression).getParsedVersion();
        }
        if (expression instanceof Greater) {
            return ">" + ((Greater)expression).getParsedVersion();
        }
        if (expression instanceof GreaterOrEqual) {
            return ">=" + ((GreaterOrEqual)expression).getParsedVersion();
        }
        if (expression instanceof And) {
            And and = (And)expression;
            String left = VersionManager.convertToNpmExpression(and.getLeft());
            String right = VersionManager.convertToNpmExpression(and.getRight());
            if (left != null && right != null) {
                return left + " " + right;
            }
            return null;
        }
        if (expression instanceof Or) {
            Or or = (Or)expression;
            String left = VersionManager.convertToNpmExpression(or.getLeft());
            String right = VersionManager.convertToNpmExpression(or.getRight());
            if (left != null && right != null) {
                return left + " || " + right;
            }
            return null;
        }
        return null;
    }

    public static String convertToMaven(String version) {
        if (VersionManager.isDevelopmentVersion(version)) {
            version = VersionManager.removeDevSuffix(version) + "-SNAPSHOT";
        }
        return version;
    }

    public static String convertToNpm(String gitRepo, String version) {
        if (VersionManager.isDevelopmentVersion(version)) {
            version = gitRepo == null ? VersionManager.removeDevSuffix(version) : gitRepo;
        }
        return version;
    }

    private static String removeDevSuffix(String version) {
        return version.substring(0, version.length() - DEV_SUFFIX_LENGTH);
    }

    private static boolean isDevelopmentVersion(String version) {
        return !VersionManager.isReleaseVersion(version);
    }

    public static boolean isReleaseVersion(String version) {
        return !version.endsWith(DEV_SUFFIX);
    }

    public static Integer versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    public static boolean devCompatibleVersion(String importVersion, String depVersion) {
        if (importVersion.equals(depVersion)) {
            return true;
        }
        if (VersionManager.isDevelopmentVersion(importVersion)) {
            importVersion = VersionManager.removeDevSuffix(importVersion);
            importVersion = "^" + importVersion;
        }
        if (VersionManager.isDevelopmentVersion(depVersion)) {
            depVersion = VersionManager.removeDevSuffix(depVersion);
        }
        return VersionManager.compatibleVersion(importVersion, depVersion);
    }

    private static String incMayorVersion(String version) {
        String[] nums = version.split("\\.");
        int mayor = Integer.parseInt(nums[0]);
        StringBuilder sb = new StringBuilder(Integer.toString(mayor + 1));
        for (int i = 1; i < nums.length; ++i) {
            sb.append(".0");
        }
        return sb.toString();
    }

    public static boolean compatibleVersion(String importVersion, String depVersion) {
        if (importVersion.equals(depVersion)) {
            return true;
        }
        if (VersionManager.isDevelopmentVersion(importVersion)) {
            return false;
        }
        Expression expression = VersionManager.parseVersion(importVersion);
        return expression.interpret(Version.valueOf(depVersion));
    }
}

