/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.codegen;

import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;

public class PathTemplateLoader
implements TemplateLoader {
    private static final boolean SEP_IS_SLASH = File.separatorChar == '/';
    public final Path baseDir;

    public PathTemplateLoader(Path baseDir) throws IOException {
        this.baseDir = baseDir;
    }

    public Object findTemplateSource(String name) throws IOException {
        String processedName = SEP_IS_SLASH ? name : name.replace('/', File.separatorChar);
        Path source = this.baseDir.resolve(processedName);
        if (!Files.exists(source, new LinkOption[0]) || Files.isDirectory(source, new LinkOption[0])) {
            return null;
        }
        return source;
    }

    public long getLastModified(Object templateSource) {
        Path templateAsPath = (Path)templateSource;
        BasicFileAttributeView basicView = Files.getFileAttributeView(templateAsPath, BasicFileAttributeView.class, new LinkOption[0]);
        if (basicView != null) {
            BasicFileAttributes basic;
            try {
                basic = basicView.readAttributes();
            }
            catch (IOException e) {
                return -1L;
            }
            return basic.lastModifiedTime().toMillis();
        }
        return -1L;
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        if (!(templateSource instanceof Path)) {
            throw new IllegalArgumentException("templateSource is a: " + templateSource.getClass().getName());
        }
        return Files.newBufferedReader((Path)templateSource, Charset.forName(encoding));
    }

    public void closeTemplateSource(Object templateSource) {
    }
}

