/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.codegen.function;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.LinkedList;
import java.util.List;
import org.kurento.modulecreator.definition.ComplexType;
import org.kurento.modulecreator.definition.Event;
import org.kurento.modulecreator.definition.Method;
import org.kurento.modulecreator.definition.Param;
import org.kurento.modulecreator.definition.Property;
import org.kurento.modulecreator.definition.RemoteClass;
import org.kurento.modulecreator.definition.Return;
import org.kurento.modulecreator.definition.Type;

public class TypeDependencies
implements TemplateMethodModelEx {
    public Object exec(List arguments) throws TemplateModelException {
        ComplexType complexType;
        Object type = arguments.get(0);
        if (type instanceof StringModel && (type = ((StringModel)type).getWrappedObject()) instanceof Return) {
            type = ((Return)type).getType();
        }
        List<Type> types = new LinkedList<Type>();
        if (type instanceof RemoteClass) {
            RemoteClass remoteClass = (RemoteClass)type;
            if (remoteClass.getConstructor() != null) {
                this.addMethodTypes(types, remoteClass.getConstructor());
            }
            for (Method method : remoteClass.getMethods()) {
                this.addMethodTypes(types, method);
            }
            for (Property property : remoteClass.getProperties()) {
                this.addDependency(types, property.getType().getType());
            }
            if (remoteClass.getExtends() != null) {
                types.remove(remoteClass.getExtends().getType());
            }
            types.remove(remoteClass);
        } else if (type instanceof Event) {
            Event event = (Event)type;
            for (Property property : event.getProperties()) {
                this.addDependency(types, property.getType().getType());
            }
            if (event.getExtends() != null) {
                types.remove(event.getExtends().getType());
            }
        } else if (type instanceof ComplexType && (complexType = (ComplexType)type).getTypeFormat() == ComplexType.TypeFormat.REGISTER) {
            for (Property property : complexType.getProperties()) {
                this.addDependency(types, property.getType().getType());
            }
            if (complexType.getExtends() != null) {
                types.remove(complexType.getExtends().getType());
            }
        }
        types = this.removeDuplicates(types);
        return types;
    }

    private void addDependency(List<Type> dependencies, Type type) {
        if (type instanceof RemoteClass || type instanceof ComplexType) {
            dependencies.add(type);
        }
    }

    private List<Type> removeDuplicates(List<Type> original) {
        LinkedList<Type> types = new LinkedList<Type>();
        for (Type t : original) {
            if (types.contains(t)) continue;
            types.add(t);
        }
        return types;
    }

    private void addMethodTypes(List<Type> dependencies, Method method) {
        for (Param p : method.getParams()) {
            this.addDependency(dependencies, p.getType().getType());
        }
        Return ret = method.getReturn();
        if (ret != null) {
            this.addDependency(dependencies, ret.getType().getType());
        }
    }
}

