/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.definition;

import org.kurento.modulecreator.KurentoModuleCreatorException;
import org.kurento.modulecreator.definition.ModelElement;
import org.kurento.modulecreator.definition.ModuleDefinition;
import org.kurento.modulecreator.definition.Type;

public class TypeRef
extends ModelElement {
    private String name;
    private boolean isList;
    private final boolean isMap;
    private transient String moduleName;
    private transient Type type;

    public static TypeRef parseFromJson(String typeRefString) {
        boolean isMap;
        boolean isList;
        String name;
        String moduleName = null;
        if (typeRefString.endsWith("[]")) {
            name = typeRefString.substring(0, typeRefString.length() - 2);
            isList = true;
            isMap = false;
        } else if (typeRefString.endsWith("<>")) {
            name = typeRefString.substring(0, typeRefString.length() - 2);
            isList = false;
            isMap = true;
        } else {
            name = typeRefString;
            isList = false;
            isMap = false;
        }
        String[] parts = name.split("\\.");
        if (parts.length == 2) {
            moduleName = parts[0];
            name = parts[1];
        } else if (parts.length > 2) {
            throw new KurentoModuleCreatorException("Invalid module name in type ref: '" + name + "'");
        }
        return new TypeRef(moduleName, name, isList, isMap);
    }

    public TypeRef(String moduleName, String name, boolean isList, boolean isMap) {
        this.moduleName = moduleName;
        this.name = name;
        this.isList = isList;
        this.isMap = isMap;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeRef other = (TypeRef)obj;
        if (this.isList != other.isList) {
            return false;
        }
        if (this.isMap != other.isMap) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isList ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public void setList(boolean isList) {
        this.isList = isList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public ModuleDefinition getModule() {
        return this.type.getModule();
    }

    public String getQualifiedName() {
        return (this.moduleName != null ? this.moduleName + "." : "") + this.name;
    }

    public String toString() {
        return "TypeRef [name=" + this.name + ", isList=" + this.isList + ", isMap=" + this.isMap + ", moduleName=" + this.moduleName + "]";
    }
}

