/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.kurento.modulecreator.definition.DataItem;
import org.kurento.modulecreator.definition.Property;

public class DataItemAdapter
implements JsonSerializer<DataItem> {
    public JsonElement serialize(DataItem src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        if (src.getName() != null) {
            object.add("name", context.serialize((Object)src.getName()));
        }
        if (src.getDoc() != null) {
            object.addProperty("doc", src.getDoc());
        }
        if (src.getType() != null) {
            object.add("type", context.serialize((Object)src.getType()));
        }
        if (src.isOptional()) {
            object.addProperty("optional", Boolean.valueOf(src.isOptional()));
            if (src.getDefaultValue() != null) {
                object.add("defaultValue", src.getDefaultValue());
            }
        }
        if (src instanceof Property) {
            Property prop = (Property)src;
            if (prop.isReadOnly()) {
                object.addProperty("readOnly", Boolean.valueOf(true));
            }
            if (prop.isFinal()) {
                object.addProperty("final", Boolean.valueOf(true));
            }
        }
        return object;
    }
}

