/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.util.DirectoryDialoger;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.util.JMeterUtils;

public class DirectoryPanel
extends HorizontalPanel
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private static final String ACTION_BROWSE = "browse";
    private final JTextField filename = new JTextField(20);
    private final JButton browse = new JButton(JMeterUtils.getResString((String)"browse"));
    private final List<ChangeListener> listeners = new LinkedList<ChangeListener>();
    private final String title;
    private final Color background;

    public DirectoryPanel() {
        this("", null);
    }

    public DirectoryPanel(String title) {
        this(title, null);
    }

    public DirectoryPanel(String title, Color bk) {
        this.title = title;
        this.background = bk;
        this.init();
    }

    public DirectoryPanel(ChangeListener l, String title) {
        this(title);
        this.listeners.add(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    private void init() {
        this.setBackground(this.background);
        this.setBorder(BorderFactory.createTitledBorder(this.title));
        this.add(Box.createHorizontalStrut(5));
        this.add(this.filename);
        this.add(Box.createHorizontalStrut(5));
        this.filename.addActionListener(this);
        this.add(this.browse);
        this.browse.setActionCommand(ACTION_BROWSE);
        this.browse.addActionListener(this);
    }

    public void enableFile(boolean enable) {
        this.browse.setEnabled(enable);
        this.filename.setEnabled(enable);
    }

    public String getFilename() {
        return this.filename.getText();
    }

    public void setFilename(String f) {
        this.filename.setText(f);
    }

    private void fireFileChanged() {
        Iterator<ChangeListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(ACTION_BROWSE)) {
            JFileChooser chooser = DirectoryDialoger.promptToOpenFile();
            if (chooser.getSelectedFile() != null) {
                this.filename.setText(chooser.getSelectedFile().getPath());
                this.fireFileChanged();
            }
        } else {
            this.fireFileChanged();
        }
    }
}

