/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jmeter.report.DataSet;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.SamplingStatCalculator;
import org.apache.jmeter.visualizers.Visualizer;

public class JTLData
implements Serializable,
DataSet {
    private static final long serialVersionUID = 240L;
    private final HashMap<String, SamplingStatCalculator> data = new HashMap();
    private String jtl_file = null;
    private long startTimestamp = 0L;
    private long endTimestamp = 0L;
    private transient File inputFile = null;

    @Override
    public Set<?> getURLs() {
        return this.data.keySet();
    }

    @Override
    public Set<SamplingStatCalculator> getStats() {
        return (Set)this.data.values();
    }

    public List getStats(List urls) {
        SamplingStatCalculator row;
        ArrayList<SamplingStatCalculator> items = new ArrayList<SamplingStatCalculator>();
        Iterator itr = urls.iterator();
        if (itr.hasNext() && (row = (SamplingStatCalculator)itr.next()) != null) {
            items.add(row);
        }
        return items;
    }

    @Override
    public void setDataSource(String absolutePath) {
        this.jtl_file = absolutePath;
    }

    @Override
    public String getDataSource() {
        return this.jtl_file;
    }

    @Override
    public String getDataSourceName() {
        if (this.inputFile == null) {
            this.inputFile = new File(this.getDataSource());
        }
        return this.inputFile.getName().substring(0, this.inputFile.getName().length() - 4);
    }

    @Override
    public void setStartTimestamp(long stamp) {
        this.startTimestamp = stamp;
    }

    @Override
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public void setEndTimestamp(long stamp) {
        this.endTimestamp = stamp;
    }

    @Override
    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public Date getDate() {
        return new Date(this.startTimestamp);
    }

    @Override
    public String getMonthDayDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.startTimestamp);
        return String.valueOf(cal.get(2)) + " - " + String.valueOf(cal.get(5));
    }

    @Override
    public String getMonthDayYearDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.startTimestamp);
        return String.valueOf(cal.get(2)) + " - " + String.valueOf(cal.get(5)) + " - " + String.valueOf(cal.get(1));
    }

    @Override
    public SamplingStatCalculator getStatistics(String url) {
        if (this.data.containsKey(url)) {
            return this.data.get(url);
        }
        return null;
    }

    @Override
    public void loadData() {
        if (this.getDataSource() != null) {
            ResultCollector rc = new ResultCollector();
            rc.setFilename(this.getDataSource());
            rc.setListener((Visualizer)this);
            rc.loadExistingFile();
            rc.clear();
            rc.setListener(null);
        }
    }

    public void add(SampleResult sample) {
        SamplingStatCalculator row;
        if (this.data.size() == 0) {
            this.startTimestamp = sample.getStartTime();
        } else {
            this.endTimestamp = sample.getEndTime();
        }
        String url = sample.getSampleLabel();
        if (url == null) {
            url = sample.getURL().toString();
        }
        if ((row = this.data.get(url)) == null) {
            row = new SamplingStatCalculator(url);
            this.data.put(url, row);
        }
        row.addSample(sample);
    }

    public boolean isStats() {
        return true;
    }
}

