/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.jmeter.report.DataSet;
import org.apache.jmeter.testelement.AbstractChart;
import org.apache.jmeter.visualizers.LineGraph;
import org.apache.jmeter.visualizers.SamplingStatCalculator;
import org.jCharts.properties.PointChartProperties;

public class LineChart
extends AbstractChart {
    private static final long serialVersionUID = 240L;
    private static final String URL_DELIM = ",";
    private static final String REPORT_CHART_URLS = "ReportChart.chart.urls";
    private static final Shape[] SHAPE_ARRAY = new Shape[]{PointChartProperties.SHAPE_CIRCLE, PointChartProperties.SHAPE_DIAMOND, PointChartProperties.SHAPE_SQUARE, PointChartProperties.SHAPE_TRIANGLE};
    private int shape_counter = 0;

    public String getURLs() {
        return this.getPropertyAsString(REPORT_CHART_URLS);
    }

    public void setURLs(String urls) {
        this.setProperty(REPORT_CHART_URLS, urls);
    }

    private double[][] convertToDouble(List<DataSet> data) {
        String[] urls = this.getURLs().split(URL_DELIM);
        double[][] dataset = new double[urls.length][data.size()];
        for (int idx = 0; idx < urls.length; ++idx) {
            for (int idz = 0; idz < data.size(); ++idz) {
                DataSet dset = data.get(idz);
                SamplingStatCalculator ss = dset.getStatistics(urls[idx]);
                dataset[idx][idz] = this.getValue(ss);
            }
        }
        return dataset;
    }

    @Override
    public JComponent renderChart(List<DataSet> dataset) {
        ArrayList<DataSet> dset = new ArrayList<DataSet>();
        ArrayList<String> xlabels = new ArrayList<String>();
        for (DataSet item : dataset) {
            if (item == null) continue;
            dset.add(item);
            if (this.getXLabel().equals("Filename")) {
                xlabels.add(item.getDataSourceName());
                continue;
            }
            xlabels.add(item.getMonthDayYearDate());
        }
        double[][] dbset = this.convertToDouble(dset);
        return this.renderGraphics(dbset, xlabels.toArray(new String[xlabels.size()]));
    }

    public JComponent renderGraphics(double[][] data, String[] xAxisLabels) {
        LineGraph panel = new LineGraph();
        panel.setTitle(this.getTitle());
        panel.setData(data);
        panel.setXAxisLabels(xAxisLabels);
        panel.setYAxisLabels(this.getURLs().split(URL_DELIM));
        panel.setXAxisTitle(this.getFormattedXAxis());
        panel.setYAxisTitle(this.getYAxis());
        int _width = this.getWidth();
        int _height = this.getHeight();
        panel.setPreferredSize(new Dimension(_width, _height));
        panel.setSize(new Dimension(_width, _height));
        panel.setWidth(_width);
        panel.setHeight(_width);
        this.setBufferedImage(new BufferedImage(_width, _height, 1));
        panel.paintComponent((Graphics)this.getBufferedImage().createGraphics());
        return panel;
    }

    public Shape[] createShapes(int count) {
        Shape[] shapes = new Shape[count];
        for (int idx = 0; idx < count; ++idx) {
            shapes[idx] = this.nextShape();
        }
        return shapes;
    }

    public Shape nextShape() {
        if (this.shape_counter >= SHAPE_ARRAY.length - 1) {
            this.shape_counter = 0;
        }
        return SHAPE_ARRAY[this.shape_counter];
    }

    public Stroke[] createStrokes(int count) {
        Stroke[] str = new Stroke[count];
        for (int idx = 0; idx < count; ++idx) {
            str[idx] = this.nextStroke();
        }
        return str;
    }

    public Stroke nextStroke() {
        return new BasicStroke(1.5f);
    }
}

