/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.beans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.URLConnection;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.beans.StringBean;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.util.EncodingChangeException;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;

public class FilterBean
implements Serializable {
    public static final String PROP_NODES_PROPERTY = "nodes";
    public static final String PROP_TEXT_PROPERTY = "text";
    public static final String PROP_URL_PROPERTY = "URL";
    public static final String PROP_CONNECTION_PROPERTY = "connection";
    protected PropertyChangeSupport mPropertySupport = new PropertyChangeSupport(this);
    protected Parser mParser = new Parser();
    protected NodeFilter[] mFilters = null;
    protected NodeList mNodes = null;
    protected boolean mRecursive = true;

    protected void updateNodes(NodeList nodes) {
        if (null == this.mNodes || !this.mNodes.equals(nodes)) {
            NodeList oldValue = this.mNodes;
            String oldText = null != oldValue ? this.getText() : "";
            if (null == oldText) {
                oldText = "";
            }
            this.mNodes = nodes;
            String newText = null != this.mNodes ? this.getText() : "";
            if (null == newText) {
                newText = "";
            }
            this.mPropertySupport.firePropertyChange(PROP_NODES_PROPERTY, oldValue, nodes);
            if (!newText.equals(oldText)) {
                this.mPropertySupport.firePropertyChange(PROP_TEXT_PROPERTY, oldText, newText);
            }
        }
    }

    protected NodeList applyFilters() throws ParserException {
        NodeList ret = this.mParser.parse(null);
        NodeFilter[] filters = this.getFilters();
        if (null != filters) {
            for (int i = 0; i < filters.length; ++i) {
                ret = ret.extractAllNodesThatMatch(filters[i], this.mRecursive);
            }
        }
        return ret;
    }

    protected void setNodes() {
        if (null != this.getURL()) {
            try {
                NodeList list = this.applyFilters();
                this.updateNodes(list);
            }
            catch (EncodingChangeException ece) {
                try {
                    this.mParser.reset();
                    NodeList list = this.applyFilters();
                    this.updateNodes(list);
                }
                catch (ParserException pe) {
                    this.updateNodes(new NodeList());
                }
            }
            catch (ParserException pe) {
                this.updateNodes(new NodeList());
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertySupport.removePropertyChangeListener(listener);
    }

    public NodeList getNodes() {
        if (null == this.mNodes) {
            this.setNodes();
        }
        return this.mNodes;
    }

    public String getURL() {
        return null != this.mParser ? this.mParser.getURL() : null;
    }

    public void setURL(String url) {
        String old = this.getURL();
        URLConnection conn = this.getConnection();
        if (null == old && null != url || null != old && !old.equals(url)) {
            try {
                if (null == this.mParser) {
                    this.mParser = new Parser(url);
                } else {
                    this.mParser.setURL(url);
                }
                this.mPropertySupport.firePropertyChange(PROP_URL_PROPERTY, old, this.getURL());
                this.mPropertySupport.firePropertyChange(PROP_CONNECTION_PROPERTY, conn, this.mParser.getConnection());
                this.setNodes();
            }
            catch (ParserException pe) {
                this.updateNodes(new NodeList());
            }
        }
    }

    public URLConnection getConnection() {
        return null != this.mParser ? this.mParser.getConnection() : null;
    }

    public void setConnection(URLConnection connection) {
        String url = this.getURL();
        URLConnection conn = this.getConnection();
        if (null == conn && null != connection || null != conn && !conn.equals(connection)) {
            try {
                if (null == this.mParser) {
                    this.mParser = new Parser(connection);
                } else {
                    this.mParser.setConnection(connection);
                }
                this.mPropertySupport.firePropertyChange(PROP_URL_PROPERTY, url, this.getURL());
                this.mPropertySupport.firePropertyChange(PROP_CONNECTION_PROPERTY, conn, this.mParser.getConnection());
                this.setNodes();
            }
            catch (ParserException pe) {
                this.updateNodes(new NodeList());
            }
        }
    }

    public NodeFilter[] getFilters() {
        return this.mFilters;
    }

    public void setFilters(NodeFilter[] filters) {
        this.mFilters = filters;
        if (null != this.getParser()) {
            this.getParser().reset();
            this.setNodes();
        }
    }

    public Parser getParser() {
        return this.mParser;
    }

    public void setParser(Parser parser) {
        this.mParser = parser;
        if (null != this.getFilters()) {
            this.setNodes();
        }
    }

    public String getText() {
        String ret;
        NodeList list = this.getNodes();
        if (0 != list.size()) {
            StringBean sb = new StringBean();
            for (int i = 0; i < list.size(); ++i) {
                list.elementAt(i).accept((NodeVisitor)sb);
            }
            ret = sb.getStrings();
        } else {
            ret = "";
        }
        return ret;
    }

    public boolean getRecursive() {
        return this.mRecursive;
    }

    public void setRecursive(boolean recursive) {
        this.mRecursive = recursive;
    }

    public static void main(String[] args) {
        if (0 >= args.length) {
            System.out.println("Usage: java -classpath htmlparser.jar org.htmlparser.beans.FilterBean <http://whatever_url> [node name]");
        } else {
            FilterBean fb = new FilterBean();
            if (1 < args.length) {
                fb.setFilters(new NodeFilter[]{new TagNameFilter(args[1])});
            }
            fb.setURL(args[0]);
            System.out.println(fb.getText());
        }
    }
}

