/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.command.DockerCmd;
import com.github.dockerjava.api.command.DockerCmdSyncExec;
import com.github.dockerjava.api.command.SyncDockerCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstrDockerCmd<CMD_T extends DockerCmd<RES_T>, RES_T>
implements SyncDockerCmd<RES_T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstrDockerCmd.class);
    protected DockerCmdSyncExec<CMD_T, RES_T> execution;

    public AbstrDockerCmd(DockerCmdSyncExec<CMD_T, RES_T> execution) {
        Preconditions.checkNotNull(execution, (Object)"execution was not specified");
        this.execution = execution;
    }

    @Override
    public RES_T exec() throws DockerException {
        LOGGER.debug("Cmd: {}", (Object)this);
        return this.execution.exec(this);
    }

    @Override
    public void close() {
    }

    protected String registryAuth(AuthConfig authConfig) {
        try {
            return Base64.encodeBase64String((byte[])new ObjectMapper().writeValueAsString((Object)authConfig).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

