/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.plugin.javadoc.JavadocReport;
import org.apache.maven.plugin.javadoc.JavadocUtil;
import org.apache.maven.plugin.javadoc.resolver.SourceResolverConfig;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="test-javadoc", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
@Execute(phase=LifecyclePhase.GENERATE_TEST_SOURCES)
public class TestJavadocReport
extends JavadocReport {
    @Parameter(property="testDoctitle", alias="doctitle", defaultValue="${project.name} ${project.version} Test API")
    private String testDoctitle;
    @Parameter(property="testOverview", alias="overview", defaultValue="${basedir}/src/test/javadoc/overview.html")
    private File testOverview;
    @Parameter(property="testWindowtitle", alias="windowtitle", defaultValue="${project.name} ${project.version} Test API")
    private String testWindowtitle;
    @Parameter(property="reportTestOutputDirectory", defaultValue="${project.reporting.outputDirectory}/testapidocs", required=true)
    private File reportOutputDirectory;
    @Parameter(property="destDir", defaultValue="testapidocs")
    private String destDir;
    @Parameter(alias="javadocDirectory", defaultValue="${basedir}/src/test/javadoc")
    private File testJavadocDirectory;
    @Parameter(property="testName", alias="name")
    private String testName;
    @Parameter(property="testDescription", alias="description")
    private String testDescription;

    @Override
    protected void executeReport(Locale unusedLocale) throws MavenReportException {
        this.addMainJavadocLink();
        super.executeReport(unusedLocale);
    }

    @Override
    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.testName)) {
            return this.getBundle(locale).getString("report.test-javadoc.name");
        }
        return this.testName;
    }

    @Override
    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.testDescription)) {
            return this.getBundle(locale).getString("report.test-javadoc.description");
        }
        return this.testDescription;
    }

    @Override
    public String getOutputName() {
        return this.destDir + "/index";
    }

    @Override
    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            return this.outputDirectory;
        }
        return this.reportOutputDirectory;
    }

    @Override
    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.updateReportOutputDirectory(reportOutputDirectory, this.destDir);
    }

    @Override
    public void setDestDir(String destDir) {
        this.destDir = destDir;
        this.updateReportOutputDirectory(this.reportOutputDirectory, destDir);
    }

    private void updateReportOutputDirectory(File reportOutputDirectory, String destDir) {
        this.reportOutputDirectory = reportOutputDirectory != null && destDir != null && !reportOutputDirectory.getAbsolutePath().endsWith(destDir) ? new File(reportOutputDirectory, destDir) : reportOutputDirectory;
    }

    @Override
    protected List<String> getProjectBuildOutputDirs(MavenProject p) {
        ArrayList<String> dirs = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)p.getBuild().getOutputDirectory())) {
            dirs.add(p.getBuild().getOutputDirectory());
        }
        if (StringUtils.isNotEmpty((String)p.getBuild().getTestOutputDirectory())) {
            dirs.add(p.getBuild().getTestOutputDirectory());
        }
        return dirs;
    }

    @Override
    protected List<String> getProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getPackaging().toLowerCase())) {
            return Collections.emptyList();
        }
        return p.getTestCompileSourceRoots() == null ? Collections.emptyList() : new LinkedList(p.getTestCompileSourceRoots());
    }

    @Override
    protected List<String> getExecutionProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getExecutionProject().getPackaging().toLowerCase())) {
            return Collections.emptyList();
        }
        return p.getExecutionProject().getTestCompileSourceRoots() == null ? Collections.emptyList() : new LinkedList(p.getExecutionProject().getTestCompileSourceRoots());
    }

    @Override
    protected List<Artifact> getProjectArtifacts(MavenProject p) {
        return p.getTestArtifacts() == null ? Collections.emptyList() : new LinkedList(p.getTestArtifacts());
    }

    @Override
    protected File getJavadocDirectory() {
        return this.testJavadocDirectory;
    }

    @Override
    protected String getDoctitle() {
        return this.testDoctitle;
    }

    @Override
    protected File getOverview() {
        return this.testOverview;
    }

    @Override
    protected String getWindowtitle() {
        return this.testWindowtitle;
    }

    @Override
    protected List<Artifact> getCompileArtifacts(ArtifactResolutionResult result) {
        return JavadocUtil.getCompileArtifacts(result.getArtifacts(), true);
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("test-javadoc-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void addMainJavadocLink() {
        File apidocs;
        if (this.links == null) {
            this.links = new ArrayList();
        }
        if ((apidocs = new File(this.getReportOutputDirectory().getParentFile(), "apidocs")).isDirectory() && !this.links.contains("../apidocs")) {
            this.links.add("../apidocs");
        }
    }

    @Override
    protected SourceResolverConfig configureDependencySourceResolution(SourceResolverConfig config) {
        return super.configureDependencySourceResolution(config).withoutCompileSources().withTestSources();
    }

    @Override
    protected boolean isTest() {
        return true;
    }
}

