/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.Reader;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.BaseFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenReaderFilter;
import org.apache.maven.shared.filtering.MavenReaderFilterRequest;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.utils.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMavenReaderFilter
extends BaseFilter
implements MavenReaderFilter {
    @Override
    @Nonnull
    public Reader filter(@Nonnull Reader from, boolean filtering, MavenProject mavenProject, List<String> filters, boolean escapedBackslashesInFilePath, MavenSession mavenSession) throws MavenFilteringException {
        MavenResourcesExecution mre = new MavenResourcesExecution();
        mre.setMavenProject(mavenProject);
        mre.setFileFilters(filters);
        mre.setEscapeWindowsPaths(escapedBackslashesInFilePath);
        mre.setMavenSession(mavenSession);
        mre.setInjectProjectBuildFilters(true);
        List<FileUtils.FilterWrapper> filterWrappers = this.getDefaultFilterWrappers(mre);
        return this.filter(from, filtering, filterWrappers);
    }

    @Override
    @Nonnull
    public Reader filter(@Nonnull MavenReaderFilterRequest mavenFileFilterRequest) throws MavenFilteringException {
        List<FileUtils.FilterWrapper> filterWrappers = this.getDefaultFilterWrappers(mavenFileFilterRequest);
        return this.filter(mavenFileFilterRequest.getFrom(), mavenFileFilterRequest.isFiltering(), filterWrappers);
    }

    @Override
    @Nonnull
    public Reader filter(@Nonnull Reader from, boolean filtering, @Nonnull List<FileUtils.FilterWrapper> filterWrappers) {
        return DefaultMavenReaderFilter.filterWrap(from, filtering ? filterWrappers : Collections.emptyList());
    }

    @Nonnull
    private static Reader filterWrap(@Nonnull Reader from, @Nonnull Iterable<FileUtils.FilterWrapper> wrappers) {
        Reader reader = from;
        for (FileUtils.FilterWrapper wrapper : wrappers) {
            reader = wrapper.getReader(reader);
        }
        return reader;
    }
}

