/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes;

import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoTypeReader;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.googlecode.mp4parser.RequiresParseDetailAspect;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSampleEncryptionBox
extends AbstractFullBox {
    int algorithmId = -1;
    int ivSize = -1;
    byte[] kid = new byte[16];
    List<Entry> entries = new LinkedList<Entry>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;

    protected AbstractSampleEncryptionBox(String type) {
        super(type);
    }

    public int getOffsetToFirstIV() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        int offset = this.getSize() > 0x100000000L ? 16 : 8;
        offset += this.isOverrideTrackEncryptionBoxParameters() ? 20 : 0;
        return offset += 4;
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        if ((this.getFlags() & 1) > 0) {
            this.algorithmId = IsoTypeReader.readUInt24(content);
            this.ivSize = IsoTypeReader.readUInt8(content);
            this.kid = new byte[16];
            content.get(this.kid);
        }
        long numOfEntries = IsoTypeReader.readUInt32(content);
        while (numOfEntries-- > 0L) {
            Entry e = new Entry();
            e.iv = new byte[(this.getFlags() & 1) > 0 ? this.ivSize : 8];
            content.get(e.iv);
            if ((this.getFlags() & 2) > 0) {
                int numOfPairs = IsoTypeReader.readUInt16(content);
                e.pairs = new LinkedList<Entry.Pair>();
                while (numOfPairs-- > 0) {
                    e.pairs.add(e.createPair(IsoTypeReader.readUInt16(content), IsoTypeReader.readUInt32(content)));
                }
            }
            this.entries.add(e);
        }
    }

    public int getSampleCount() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries.size();
    }

    public List<Entry> getEntries() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.entries;
    }

    /*
     * WARNING - void declaration
     */
    public void setEntries(List<Entry> list) {
        void entries;
        List<Entry> list2 = list;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, list2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.entries = entries;
    }

    public int getAlgorithmId() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.algorithmId;
    }

    /*
     * WARNING - void declaration
     */
    public void setAlgorithmId(int n) {
        void algorithmId;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.algorithmId = algorithmId;
    }

    public int getIvSize() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.ivSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setIvSize(int n) {
        void ivSize;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.intObject((int)n2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.ivSize = ivSize;
    }

    public byte[] getKid() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.kid;
    }

    /*
     * WARNING - void declaration
     */
    public void setKid(byte[] byArray) {
        void kid;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)byArray2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.kid = kid;
    }

    public boolean isSubSampleEncryption() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 2) > 0;
    }

    public boolean isOverrideTrackEncryptionBoxParameters() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return (this.getFlags() & 1) > 0;
    }

    /*
     * WARNING - void declaration
     */
    public void setSubSampleEncryption(boolean bl) {
        void b;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (b != false) {
            this.setFlags(this.getFlags() | 2);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFD);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setOverrideTrackEncryptionBoxParameters(boolean bl) {
        void b;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl2));
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (b != false) {
            this.setFlags(this.getFlags() | 1);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFE);
        }
    }

    @Override
    protected void getContent(ByteBuffer bb) throws IOException {
        this.writeVersionAndFlags(bb);
        if (this.isOverrideTrackEncryptionBoxParameters()) {
            IsoTypeWriter.writeUInt24(bb, this.algorithmId);
            IsoTypeWriter.writeUInt8(bb, this.ivSize);
            bb.put(this.kid);
        }
        IsoTypeWriter.writeUInt32(bb, this.entries.size());
        for (Entry entry : this.entries) {
            if (this.isOverrideTrackEncryptionBoxParameters()) {
                byte[] ivFull = new byte[this.ivSize];
                System.arraycopy(entry.iv, 0, ivFull, this.ivSize - entry.iv.length, entry.iv.length);
                bb.put(ivFull);
            } else {
                bb.put(entry.iv);
            }
            if (!this.isSubSampleEncryption()) continue;
            IsoTypeWriter.writeUInt16(bb, entry.pairs.size());
            for (Entry.Pair pair : entry.pairs) {
                IsoTypeWriter.writeUInt16(bb, pair.clear);
                IsoTypeWriter.writeUInt32(bb, pair.encrypted);
            }
        }
    }

    @Override
    protected long getContentSize() {
        long contentSize = 4L;
        if (this.isOverrideTrackEncryptionBoxParameters()) {
            contentSize += 4L;
            contentSize += (long)this.kid.length;
        }
        contentSize += 4L;
        for (Entry entry : this.entries) {
            contentSize += (long)entry.getSize();
        }
        return contentSize;
    }

    @Override
    public void getBox(WritableByteChannel os) throws IOException {
        super.getBox(os);
    }

    public Entry createEntry() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return new Entry();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        void o;
        Object object2 = object;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)object2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSampleEncryptionBox that = (AbstractSampleEncryptionBox)o;
        if (this.algorithmId != that.algorithmId) {
            return false;
        }
        if (this.ivSize != that.ivSize) {
            return false;
        }
        if (this.entries != null ? !this.entries.equals(that.entries) : that.entries != null) {
            return false;
        }
        return Arrays.equals(this.kid, that.kid);
    }

    public int hashCode() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        int result = this.algorithmId;
        result = 31 * result + this.ivSize;
        result = 31 * result + (this.kid != null ? Arrays.hashCode(this.kid) : 0);
        result = 31 * result + (this.entries != null ? this.entries.hashCode() : 0);
        return result;
    }

    public List<Short> getEntrySizes() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        ArrayList<Short> entrySizes = new ArrayList<Short>(this.entries.size());
        for (Entry entry : this.entries) {
            short size = (short)entry.iv.length;
            if (this.isSubSampleEncryption()) {
                size = (short)(size + 2);
                size = (short)(size + entry.pairs.size() * 6);
            }
            entrySizes.add(size);
        }
        return entrySizes;
    }

    static {
        AbstractSampleEncryptionBox.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractSampleEncryptionBox.java", AbstractSampleEncryptionBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOffsetToFirstIV", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "int"), 28);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSampleCount", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "int"), 62);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSubSampleEncryption", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "boolean"), 99);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isOverrideTrackEncryptionBoxParameters", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "boolean"), 103);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSubSampleEncryption", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "boolean", "b", "", "void"), 107);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setOverrideTrackEncryptionBoxParameters", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "boolean", "b", "", "void"), 115);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createEntry", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox$Entry"), 171);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "java.lang.Object", "o", "", "boolean"), 268);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "int"), 283);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEntrySizes", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "java.util.List"), 291);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getEntries", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "java.util.List"), 66);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setEntries", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "java.util.List", "entries", "", "void"), 70);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAlgorithmId", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "int"), 74);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setAlgorithmId", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "int", "algorithmId", "", "void"), 78);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIvSize", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "int"), 82);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setIvSize", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "int", "ivSize", "", "void"), 86);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getKid", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "", "", "", "[B"), 90);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setKid", "com.googlecode.mp4parser.boxes.AbstractSampleEncryptionBox", "[B", "kid", "", "void"), 94);
    }

    public class Entry {
        public byte[] iv;
        public List<Pair> pairs = new LinkedList<Pair>();

        public int getSize() {
            int size = 0;
            size = AbstractSampleEncryptionBox.this.isOverrideTrackEncryptionBoxParameters() ? AbstractSampleEncryptionBox.this.ivSize : this.iv.length;
            if (AbstractSampleEncryptionBox.this.isSubSampleEncryption()) {
                size += 2;
                Iterator<Pair> iterator = this.pairs.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    size += 6;
                }
            }
            return size;
        }

        public Pair createPair(int clear, long encrypted) {
            return new Pair(clear, encrypted);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!new BigInteger(this.iv).equals(new BigInteger(entry.iv))) {
                return false;
            }
            return !(this.pairs != null ? !this.pairs.equals(entry.pairs) : entry.pairs != null);
        }

        public int hashCode() {
            int result = this.iv != null ? Arrays.hashCode(this.iv) : 0;
            result = 31 * result + (this.pairs != null ? this.pairs.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Entry{iv=" + Hex.encodeHex(this.iv) + ", pairs=" + this.pairs + '}';
        }

        public class Pair {
            public int clear;
            public long encrypted;

            public Pair(int clear, long encrypted) {
                this.clear = clear;
                this.encrypted = encrypted;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Pair pair = (Pair)o;
                if (this.clear != pair.clear) {
                    return false;
                }
                return this.encrypted == pair.encrypted;
            }

            public int hashCode() {
                int result = this.clear;
                result = 31 * result + (int)(this.encrypted ^ this.encrypted >>> 32);
                return result;
            }

            public String toString() {
                return "clr:" + this.clear + " enc:" + this.encrypted;
            }
        }
    }
}

