/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.mock;

import java.util.HashMap;
import java.util.Map;
import org.apache.struts.action.ActionForm;

public class MockFormBean
extends ActionForm {
    private boolean throwException = false;
    private boolean returnNulls = false;
    private String defaultValue;
    private Double defaultDouble;
    private int arrayCount;
    protected boolean booleanProperty = false;
    protected String stringProperty = null;

    public MockFormBean() {
        this(null);
    }

    public MockFormBean(boolean throwException, boolean returnNulls) {
        this.throwException = throwException;
        this.returnNulls = returnNulls;
    }

    public MockFormBean(boolean throwException) {
        this.throwException = throwException;
    }

    public MockFormBean(boolean throwException, boolean returnNulls, String defaultValue) {
        this(throwException, returnNulls);
        this.defaultValue = defaultValue;
    }

    public MockFormBean(String stringProperty) {
        this.stringProperty = stringProperty;
    }

    public MockFormBean(boolean throwException, boolean returnNulls, String defaultValue, int arrayCount) {
        this(throwException, returnNulls, defaultValue);
        this.arrayCount = arrayCount;
    }

    public MockFormBean(boolean throwException, boolean returnNulls, Double defaultDouble) {
        this(throwException, returnNulls);
        this.defaultDouble = defaultDouble;
    }

    public String getJustThrowAnException() throws Exception {
        throw new Exception();
    }

    public Object getThrowIllegalAccessException() throws Exception {
        throw new IllegalAccessException();
    }

    public String getStringValue() throws Exception {
        if (this.throwException) {
            throw new Exception();
        }
        if (this.returnNulls) {
            return null;
        }
        return this.defaultValue;
    }

    public String[] getStringArray() throws Exception {
        if (this.throwException) {
            throw new Exception();
        }
        if (this.returnNulls) {
            return null;
        }
        String[] rtn = new String[this.arrayCount];
        for (int i = 0; i < rtn.length; ++i) {
            rtn[i] = this.defaultValue + i;
        }
        return rtn;
    }

    public Double getDoubleValue() throws Exception {
        if (this.throwException) {
            throw new Exception();
        }
        if (this.returnNulls) {
            return null;
        }
        return this.defaultDouble;
    }

    public boolean getBooleanProperty() {
        return this.booleanProperty;
    }

    public void setBooleanProperty(boolean booleanProperty) {
        this.booleanProperty = booleanProperty;
    }

    public Map getMapProperty() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo1", "bar1");
        map.put("foo2", "bar2");
        return map;
    }

    public Map getMapPropertyArrayValues() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("foo1", new String[]{"bar1", "baz1"});
        map.put("foo2", new String[]{"bar2", "baz2"});
        return map;
    }

    public String getStringProperty() {
        return this.stringProperty;
    }

    public void setStringProperty(String stringProperty) {
        this.stringProperty = stringProperty;
    }
}

