/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.ant.tasks.support;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

public class SpecificScopesArtifactFilter
implements ArtifactFilter {
    private boolean compileScope;
    private boolean runtimeScope;
    private boolean testScope;
    private boolean providedScope;
    private boolean systemScope;

    public SpecificScopesArtifactFilter(String scopes) {
        String[] scopeList;
        for (String aScopeList : scopeList = scopes.split(",")) {
            if (aScopeList.trim().equals("compile")) {
                this.compileScope = true;
                continue;
            }
            if (aScopeList.trim().equals("provided")) {
                this.providedScope = true;
                continue;
            }
            if (aScopeList.trim().equals("runtime")) {
                this.runtimeScope = true;
                continue;
            }
            if (aScopeList.trim().equals("system")) {
                this.systemScope = true;
                continue;
            }
            if (!aScopeList.trim().equals("test")) continue;
            this.testScope = true;
        }
    }

    public boolean include(Artifact artifact) {
        if ("compile".equals(artifact.getScope())) {
            return this.compileScope;
        }
        if ("runtime".equals(artifact.getScope())) {
            return this.runtimeScope;
        }
        if ("test".equals(artifact.getScope())) {
            return this.testScope;
        }
        if ("provided".equals(artifact.getScope())) {
            return this.providedScope;
        }
        if ("system".equals(artifact.getScope())) {
            return this.systemScope;
        }
        return true;
    }
}

