/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.io.Reader;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import net.javacrumbs.jsonunit.core.internal.AbstractNode;
import net.javacrumbs.jsonunit.core.internal.AbstractNodeFactory;
import net.javacrumbs.jsonunit.core.internal.ArrayUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.mapper.Mapper;
import org.apache.johnzon.mapper.MapperBuilder;

public class JohnzonNodeFactory
extends AbstractNodeFactory {
    private final Mapper mapper = new MapperBuilder().build();

    @Override
    protected Node doConvertValue(Object source) {
        if (source instanceof JsonValue) {
            return JohnzonNodeFactory.newNode((JsonValue)source);
        }
        if (source instanceof int[]) {
            return JohnzonNodeFactory.newNode(this.mapper.toStructure(ArrayUtils.toIntList((int[])source)));
        }
        if (source instanceof double[]) {
            return JohnzonNodeFactory.newNode(this.mapper.toStructure(ArrayUtils.toDoubleList((double[])source)));
        }
        if (source instanceof boolean[]) {
            return JohnzonNodeFactory.newNode(this.mapper.toStructure(ArrayUtils.toBoolList((boolean[])source)));
        }
        if (source instanceof Object[]) {
            return JohnzonNodeFactory.newNode(this.mapper.toStructure(Arrays.asList((Object[])source)));
        }
        return JohnzonNodeFactory.newNode(this.mapper.toStructure(source));
    }

    @Override
    protected Node nullNode() {
        return JohnzonNodeFactory.newNode(JsonValue.NULL);
    }

    @Override
    protected Node readValue(Reader reader, String label, boolean lenient) {
        Throwable throwable = null;
        try (JsonReader parser = Json.createReader((Reader)reader);){
            Node node = JohnzonNodeFactory.newNode(parser.readValue());
            return node;
        }
        catch (JsonParsingException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public boolean isPreferredFor(Object source) {
        return source instanceof JsonValue;
    }

    private static Node newNode(JsonValue value) {
        return new JavaxJsonNode(value);
    }

    static final class JavaxJsonNode
    extends AbstractNode {
        private final JsonValue jsonNode;

        JavaxJsonNode(JsonValue jsonNode) {
            this.jsonNode = jsonNode;
        }

        @Override
        public Node element(int index) {
            if (this.jsonNode instanceof JsonArray) {
                try {
                    return JohnzonNodeFactory.newNode((JsonValue)((JsonArray)this.jsonNode).get(index));
                }
                catch (IndexOutOfBoundsException e) {
                    return MISSING_NODE;
                }
            }
            throw new IllegalStateException("Can call element() only on an JsonArray");
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            if (this.jsonNode instanceof JsonObject) {
                final Iterator iterator = ((JsonObject)this.jsonNode).entrySet().iterator();
                return new Iterator<Node.KeyValue>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }

                    @Override
                    public Node.KeyValue next() {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        return new Node.KeyValue((String)entry.getKey(), JohnzonNodeFactory.newNode((JsonValue)entry.getValue()));
                    }
                };
            }
            throw new IllegalStateException("Can call fields() only on an JsonObject");
        }

        @Override
        public Node get(String key) {
            if (this.jsonNode instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)this.jsonNode;
                if (jsonObject.containsKey((Object)key)) {
                    return JohnzonNodeFactory.newNode((JsonValue)jsonObject.get((Object)key));
                }
                return Node.MISSING_NODE;
            }
            return Node.MISSING_NODE;
        }

        @Override
        public boolean isMissingNode() {
            return false;
        }

        @Override
        public boolean isNull() {
            return this.jsonNode.equals(JsonValue.NULL);
        }

        @Override
        public Iterator<Node> arrayElements() {
            if (this.jsonNode instanceof JsonArray) {
                final Iterator iterator = ((JsonArray)this.jsonNode).iterator();
                return new Iterator<Node>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }

                    @Override
                    public Node next() {
                        return JohnzonNodeFactory.newNode((JsonValue)iterator.next());
                    }
                };
            }
            throw new IllegalStateException("Can call arrayElements() only on an JsonArray");
        }

        @Override
        public int size() {
            if (this.jsonNode instanceof JsonArray) {
                return ((JsonArray)this.jsonNode).size();
            }
            throw new IllegalStateException("Can call size() only on an JsonArray");
        }

        @Override
        public Node.NodeType getNodeType() {
            switch (this.jsonNode.getValueType()) {
                case OBJECT: {
                    return Node.NodeType.OBJECT;
                }
                case ARRAY: {
                    return Node.NodeType.ARRAY;
                }
                case STRING: {
                    return Node.NodeType.STRING;
                }
                case NUMBER: {
                    return Node.NodeType.NUMBER;
                }
                case TRUE: {
                    return Node.NodeType.BOOLEAN;
                }
                case FALSE: {
                    return Node.NodeType.BOOLEAN;
                }
                case NULL: {
                    return Node.NodeType.NULL;
                }
            }
            throw new IllegalStateException("Unexpected node type " + this.jsonNode);
        }

        @Override
        public String asText() {
            if (this.jsonNode.getValueType() == JsonValue.ValueType.STRING) {
                return ((JsonString)this.jsonNode).getString();
            }
            throw new IllegalStateException("Not a JsonString: " + this.jsonNode);
        }

        @Override
        public BigDecimal decimalValue() {
            if (this.isNumber()) {
                return ((JsonNumber)this.jsonNode).bigDecimalValue();
            }
            throw new IllegalStateException("Not a JsonNumber: " + this.jsonNode);
        }

        @Override
        public boolean isIntegralNumber() {
            return this.jsonNode instanceof JsonLongImpl;
        }

        private boolean isNumber() {
            return this.jsonNode.getValueType() == JsonValue.ValueType.NUMBER;
        }

        @Override
        public Boolean asBoolean() {
            if (this.jsonNode.getValueType() == JsonValue.ValueType.TRUE) {
                return true;
            }
            if (this.jsonNode.getValueType() == JsonValue.ValueType.FALSE) {
                return false;
            }
            throw new IllegalStateException("Not a JsonBoolean: " + this.jsonNode);
        }

        public String toString() {
            return this.jsonNode.toString();
        }
    }
}

