/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class CircularLinkedList<V>
extends LinkedList<V> {
    private final int maxSize;

    public CircularLinkedList(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public void addFirst(V v) {
        if (this.size() > this.maxSize - 1) {
            this.removeFirst();
        }
        super.addFirst(v);
    }

    @Override
    public void addLast(V v) {
        super.addLast(v);
        if (this.size() > this.maxSize) {
            this.removeFirst();
        }
    }

    @Override
    public boolean add(V v) {
        boolean changed = super.add(v);
        if (this.size() > this.maxSize) {
            this.removeFirst();
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean changed = false;
        for (V value : c) {
            if (!this.add(value)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> c) {
        ArrayList<V> objects = new ArrayList<V>(c);
        for (int i = 0; i < c.size(); ++i) {
            this.add(index, (V)objects.get(i));
        }
        return true;
    }

    @Override
    public void add(int index, V element) {
        if (index < this.size()) {
            super.add(index, element);
            if (this.size() > this.maxSize) {
                this.removeFirst();
            }
        } else {
            throw new IllegalArgumentException("Index [" + index + "] is greater then the max size [" + this.maxSize + "]");
        }
    }
}

