/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.echo.http.EchoServerInitializer;
import org.mockserver.log.MockServerEventLog;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpResponse;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.stop.Stoppable;
import org.slf4j.event.Level;

public class EchoServer
implements Stoppable {
    static final AttributeKey<MockServerEventLog> LOG_FILTER = AttributeKey.valueOf("SERVER_LOG_FILTER");
    static final AttributeKey<NextResponse> NEXT_RESPONSE = AttributeKey.valueOf("NEXT_RESPONSE");
    private static final MockServerLogger mockServerLogger = new MockServerLogger(EchoServer.class);
    private final Scheduler scheduler = new Scheduler(mockServerLogger);
    private final MockServerEventLog mockServerEventLog = new MockServerEventLog(mockServerLogger, this.scheduler, true);
    private final NextResponse nextResponse = new NextResponse();
    private final CompletableFuture<Integer> boundPort = new CompletableFuture();
    private final List<String> registeredClients = new ArrayList<String>();
    private final List<Channel> websocketChannels = new ArrayList<Channel>();
    private final List<TextWebSocketFrame> textWebSocketFrames = new ArrayList<TextWebSocketFrame>();
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public EchoServer(boolean secure) {
        this(secure, null, null);
    }

    public EchoServer(SslContext sslContext) {
        this(true, sslContext, null);
    }

    public EchoServer(boolean secure, Error error) {
        this(secure, null, error);
    }

    public EchoServer(boolean secure, SslContext sslContext, Error error) {
        new Thread(() -> {
            this.bossGroup = new NioEventLoopGroup(3, new Scheduler.SchedulerThreadFactory(this.getClass().getSimpleName() + "-bossEventLoop"));
            this.workerGroup = new NioEventLoopGroup(5, new Scheduler.SchedulerThreadFactory(this.getClass().getSimpleName() + "-workerEventLoop"));
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, 100)).handler(new LoggingHandler(EchoServer.class))).childHandler(new EchoServerInitializer(mockServerLogger, secure, sslContext, error, this.registeredClients, this.websocketChannels, this.textWebSocketFrames)).childAttr(LOG_FILTER, this.mockServerEventLog).childAttr(NEXT_RESPONSE, this.nextResponse).bind(0).addListener(future -> {
                if (future.isSuccess()) {
                    this.boundPort.complete(((InetSocketAddress)future.channel().localAddress()).getPort());
                } else {
                    this.boundPort.completeExceptionally(future.cause());
                }
            });
        }, "MockServer EchoServer Thread").start();
        try {
            this.boundPort.get(ConfigurationProperties.maxFutureTimeout(), TimeUnit.MILLISECONDS);
            TimeUnit.MILLISECONDS.sleep(5L);
        }
        catch (Exception e) {
            mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception while waiting for proxy to complete starting up").setThrowable(e));
        }
    }

    @Override
    public void stop() {
        this.scheduler.shutdown();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    @Override
    public void close() {
        this.stop();
    }

    public Integer getPort() {
        try {
            return this.boundPort.get(ConfigurationProperties.maxFutureTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public MockServerEventLog mockServerEventLog() {
        return this.mockServerEventLog;
    }

    public void withNextResponse(HttpResponse ... httpResponses) {
        this.nextResponse.httpResponse.addAll(Arrays.asList(httpResponses));
    }

    public void clearNextResponse() {
        this.nextResponse.httpResponse.clear();
    }

    public List<String> getRegisteredClients() {
        return this.registeredClients;
    }

    public List<Channel> getWebsocketChannels() {
        return this.websocketChannels;
    }

    public List<TextWebSocketFrame> getTextWebSocketFrames() {
        return this.textWebSocketFrames;
    }

    public static class NextResponse {
        public final Queue<HttpResponse> httpResponse = new LinkedList<HttpResponse>();
    }

    public static enum Error {
        CLOSE_CONNECTION,
        LARGER_CONTENT_LENGTH,
        SMALLER_CONTENT_LENGTH,
        RANDOM_BYTES_RESPONSE;

    }
}

