/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.model.HttpRequest;

public class MatchDifference {
    private final HttpRequest httpRequest;
    private final Map<String, List<String>> differences = new ConcurrentHashMap<String, List<String>>();
    private String fieldName;
    private Integer failures = 0;

    public MatchDifference(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public MatchDifference addDifference(String messageFormat, Object ... arguments) {
        if (ConfigurationProperties.detailedMatchFailures() && ObjectUtils.isNotEmpty(messageFormat) && arguments != null && ObjectUtils.isNotEmpty(this.fieldName)) {
            this.differences.computeIfAbsent(this.fieldName, key -> new ArrayList()).add(StringFormatter.formatLogMessage(1, messageFormat, arguments));
        }
        return this;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    protected MatchDifference currentField(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public List<String> getDifferences(String fieldName) {
        return this.differences.get(fieldName);
    }

    public MatchDifference incrementFailures() {
        MatchDifference matchDifference = this;
        Integer n = matchDifference.failures;
        Integer n2 = matchDifference.failures = Integer.valueOf(matchDifference.failures + 1);
        return this;
    }

    public Integer getFailures() {
        return this.failures;
    }
}

