/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.validator.xmlschema.XmlSchemaValidator;
import org.slf4j.event.Level;

public class XmlSchemaMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger", "xmlSchemaValidator"};
    private final MockServerLogger mockServerLogger;
    private String matcher;
    private XmlSchemaValidator xmlSchemaValidator;

    XmlSchemaMatcher(MockServerLogger mockServerLogger, String matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
        this.xmlSchemaValidator = new XmlSchemaValidator(mockServerLogger, matcher);
    }

    @Override
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        boolean result = false;
        try {
            String validation = this.xmlSchemaValidator.isValid(matched);
            result = validation.isEmpty();
            if (!result) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("xml schema match failed expected:{}found:{}failed because:{}").setArguments(this.matcher, matched, validation));
            }
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("xml schema match failed expected:{}found:{}failed because:{}").setArguments(this.matcher, matched, e.getMessage()));
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return StringUtils.isBlank(this.matcher);
    }
}

