/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty.proxy.relay;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.ssl.SslHandler;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.netty.unification.PortUnificationHandler;
import org.slf4j.event.Level;

public class UpstreamProxyRelayHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final MockServerLogger mockServerLogger;
    private final Channel upstreamChannel;
    private final Channel downstreamChannel;

    public UpstreamProxyRelayHandler(MockServerLogger mockServerLogger, Channel upstreamChannel, Channel downstreamChannel) {
        super(false);
        this.upstreamChannel = upstreamChannel;
        this.downstreamChannel = downstreamChannel;
        this.mockServerLogger = mockServerLogger;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
        ctx.write(Unpooled.EMPTY_BUFFER);
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (PortUnificationHandler.isSslEnabledDownstream(this.upstreamChannel) && this.downstreamChannel.pipeline().get(SslHandler.class) == null) {
            this.downstreamChannel.pipeline().addFirst(PortUnificationHandler.nettySslContextFactory(ctx.channel()).createClientSslContext(true).newHandler(ctx.alloc()));
        }
        this.downstreamChannel.writeAndFlush(request).addListener(future -> {
            if (future.isSuccess()) {
                ctx.channel().read();
            } else {
                if (this.isNotSocketClosedException(future.cause())) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception while returning response for request \"" + request.method() + " " + request.uri() + "\"").setThrowable(future.cause()));
                }
                future.channel().close();
            }
        });
    }

    private boolean isNotSocketClosedException(Throwable cause) {
        return !(cause instanceof ClosedChannelException) && !(cause instanceof ClosedSelectorException);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        ExceptionHandling.closeOnFlush(this.downstreamChannel);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException(cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception caught by upstream relay handler -> closing pipeline " + ctx.channel()).setThrowable(cause));
        }
        ExceptionHandling.closeOnFlush(ctx.channel());
    }
}

