/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.response;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.model.LogEventBody;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XmlBody;

public class HttpResponseSerializer
extends StdSerializer<HttpResponse> {
    public HttpResponseSerializer() {
        super(HttpResponse.class);
    }

    @Override
    public void serialize(HttpResponse httpResponse, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        BodyWithContentType body;
        jgen.writeStartObject();
        if (httpResponse.getStatusCode() != null) {
            jgen.writeObjectField("statusCode", httpResponse.getStatusCode());
        }
        if (httpResponse.getReasonPhrase() != null) {
            jgen.writeObjectField("reasonPhrase", httpResponse.getReasonPhrase());
        }
        if (httpResponse.getHeaderList() != null && !httpResponse.getHeaderList().isEmpty()) {
            jgen.writeObjectField("headers", httpResponse.getHeaders());
        }
        if (httpResponse.getCookieList() != null && !httpResponse.getCookieList().isEmpty()) {
            jgen.writeObjectField("cookies", httpResponse.getCookies());
        }
        if ((body = httpResponse.getBody()) != null) {
            if (body instanceof StringBody && !((StringBody)body).getValue().isEmpty()) {
                jgen.writeObjectField("body", body);
            } else if (body instanceof JsonBody && !((JsonBody)body).getValue().isEmpty()) {
                jgen.writeObjectField("body", body);
            } else if (body instanceof BinaryBody && ((BinaryBody)body).getValue().length > 0) {
                jgen.writeObjectField("body", body);
            } else if (body instanceof ParameterBody && !((ParameterBody)((Object)body)).getValue().isEmpty()) {
                jgen.writeObjectField("body", body);
            } else if (body instanceof XmlBody && !((XmlBody)body).getValue().isEmpty()) {
                jgen.writeObjectField("body", body);
            } else if (body instanceof LogEventBody) {
                jgen.writeObjectField("body", body);
            }
        }
        if (httpResponse.getDelay() != null) {
            jgen.writeObjectField("delay", httpResponse.getDelay());
        }
        if (httpResponse.getConnectionOptions() != null) {
            jgen.writeObjectField("connectionOptions", httpResponse.getConnectionOptions());
        }
        jgen.writeEndObject();
    }
}

