/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit;

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.raml.parser.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class CharsetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CharsetUtils.class);

    public static String getEncoding(MuleMessage message, byte[] bytes, Logger logger) {
        String encoding = CharsetUtils.getHeaderCharset(message, logger);
        if (encoding == null) {
            encoding = StreamUtils.detectEncoding((byte[])bytes);
            logger.debug("Detected payload encoding: " + CharsetUtils.logEncoding(encoding));
            if (encoding == null) {
                encoding = message.getEncoding();
                logger.debug("Defaulting to mule message encoding: " + CharsetUtils.logEncoding(encoding));
            }
        }
        if (encoding.matches("(?i)UTF-16.+")) {
            encoding = "UTF-16";
        }
        return encoding;
    }

    public static String getXmlEncoding(MuleEvent muleEvent, byte[] payload, Document document, Logger logger) {
        String encoding = document.getXmlEncoding();
        logger.debug("Xml declaration encoding: " + CharsetUtils.logEncoding(encoding));
        if (encoding == null) {
            encoding = StreamUtils.detectEncoding((byte[])payload);
            logger.debug("Detected payload encoding: " + CharsetUtils.logEncoding(encoding));
        }
        if (encoding == null) {
            encoding = muleEvent.getEncoding();
            logger.debug("Defaulting to mule message encoding: " + CharsetUtils.logEncoding(encoding));
        }
        return encoding;
    }

    public static String getHeaderCharset(MuleMessage message, Logger logger) {
        String charset = null;
        String contentType = (String)message.getInboundProperty("Content-Type", (Object)"application/xml");
        if (contentType.contains("charset=")) {
            charset = message.getEncoding();
            logger.debug("Request Content-Type charset: " + CharsetUtils.logEncoding(charset));
        }
        return charset;
    }

    public static byte[] trimBom(byte[] content) {
        int bomSize = 0;
        if (content.length > 4 && (content[0] == 0 && content[1] == 0 && content[2] == -2 && content[3] == -1 || content[0] == -1 && content[1] == -2 && content[2] == 0 && content[3] == 0)) {
            bomSize = 4;
        }
        if (content.length > 3 && bomSize == 0 && content[0] == -17 && content[1] == -69 && content[2] == -65) {
            bomSize = 3;
        }
        if (content.length > 2 && bomSize == 0 && (content[0] == -2 && content[1] == -1 || content[0] == -1 && content[1] == -2)) {
            bomSize = 2;
        }
        if (bomSize > 0) {
            LOGGER.debug("Trimming {}-byte BOM", (Object)bomSize);
            int trimmedSize = content.length - bomSize;
            byte[] trimmedArray = new byte[trimmedSize];
            System.arraycopy(content, bomSize, trimmedArray, 0, trimmedSize);
            return trimmedArray;
        }
        return content;
    }

    private static String logEncoding(String encoding) {
        return encoding != null ? encoding : "not specified";
    }
}

