/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.validation.cache;

import com.github.fge.jsonschema.main.JsonSchema;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.mule.api.MuleContext;
import org.mule.api.registry.RegistrationException;
import org.mule.module.apikit.validation.cache.JsonSchemaCacheLoader;
import org.mule.raml.interfaces.model.IRaml;

public final class JsonSchemaCache {
    private static final String REGISTRY_JSON_SCHEMA_CACHE_KEY_PREFIX = "__restRouterJsonSchemaCache__";

    public static LoadingCache<String, JsonSchema> getJsonSchemaCache(MuleContext muleContext, String configId, IRaml api) throws RegistrationException {
        String cacheKey = REGISTRY_JSON_SCHEMA_CACHE_KEY_PREFIX + configId;
        if (muleContext.getRegistry().get(cacheKey) == null) {
            LoadingCache transformerCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new JsonSchemaCacheLoader(api));
            muleContext.getRegistry().registerObject(cacheKey, (Object)transformerCache);
        }
        return (LoadingCache)muleContext.getRegistry().get(cacheKey);
    }
}

