/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import java.util.Locale;
import org.mule.api.MuleEvent;
import org.mule.config.i18n.Message;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;

public class TimeValidator
extends AbstractValidator {
    private final String time;
    private final String locale;
    private final String pattern;
    private Message errorMessage;

    public TimeValidator(String time, String locale, String pattern, ValidationContext validationContext) {
        super(validationContext);
        this.time = time;
        this.locale = locale;
        this.pattern = pattern;
    }

    @Override
    public ValidationResult validate(MuleEvent event) {
        org.apache.commons.validator.routines.TimeValidator validator = org.apache.commons.validator.routines.TimeValidator.getInstance();
        Locale locale = new Locale(this.locale);
        if (this.pattern != null) {
            if (!validator.isValid(this.time, this.pattern, locale)) {
                this.errorMessage = this.getMessages().invalidTime(this.time, this.locale, this.pattern);
                return this.fail();
            }
        } else if (!validator.isValid(this.time, locale)) {
            this.errorMessage = this.getMessages().invalidTime(this.time, this.locale, this.pattern);
            return this.fail();
        }
        return ImmutableValidationResult.ok();
    }

    @Override
    protected Message getDefaultErrorMessage() {
        return this.errorMessage;
    }
}

