/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.apidoc.desarializer;

import com.google.gson.*;
import org.mule.devkit.model.apidoc.config.*;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.TreeMap;

public class ConfigSerializer implements JsonSerializer<Config>, JsonDeserializer<Config> {

    private final static String TYPE = "type";

    private static Map<String, Class> map = new TreeMap<String, Class>();

    static {
        map.put(ConfigurationConfig.class.getSimpleName(), ConfigurationConfig.class);
        map.put(OAuth2Config.class.getSimpleName(), OAuth2Config.class);
        map.put(ConnectionManagementConfig.class.getSimpleName(), ConnectionManagementConfig.class);
        map.put(WsdlProviderConfig.class.getSimpleName(), WsdlProviderConfig.class);
    }

    public JsonElement serialize(Config src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = context.serialize(src, src.getClass()).getAsJsonObject();
        result.add(TYPE, new JsonPrimitive(src.getClass().getSimpleName()));
        return result;
    }

    @Override
    public Config deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String type = jsonObject.get(TYPE).getAsString();
        return context.deserialize(json, map.get(type));
    }
}

