/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.apidoc.operation;

import org.mule.devkit.model.apidoc.AbstractElement;
import org.mule.devkit.model.apidoc.Variable;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents an Operation of the Module
 * One of @Source, @Processor, @Transformer or @Filter
 */
public abstract class Operation extends AbstractElement {

    private List<String> samples;
    private Variable javaReturnType;
    private List<Variable> parameters;
    private String apiDocUrl;

    public List<Variable> parameters() {
        return new ArrayList<>(parameters);
    }

    public Variable javaReturnType() {
        return javaReturnType;
    }

    public List<String> samples(){
        return samples;
    }

    public String apiDocUrl() {
        return setEmptyForNull(apiDocUrl);
    }

    public void apiDocUrl(String apiDocUrl) {
        this.apiDocUrl = apiDocUrl;
    }

    public void javaReturnType(Variable javaReturnType) {
        this.javaReturnType = javaReturnType;
    }

    public void parameters(List<Variable> parameters) {
        this.parameters = parameters;
    }

    public void samples(List<String> sample) {
        this.samples = sample;
    }

    public Boolean isPaged(){
        return false;
    }

    public Boolean isBatch(){
        return false;
    }

}
