/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.model.apidoc.operation;

import org.mule.devkit.model.apidoc.Variable;
import org.mule.devkit.model.apidoc.metadata.Metadata;

/**
 * Represents a @Processor Operation
 */
public class ProcessorOperation extends Operation implements Metadata {

    private Boolean isPaged = false;
    private Boolean isBatch = false;

    @Override
    public Boolean isBatch() {
        return isBatch;
    }

    @Override
    public Boolean isPaged() {
        return isPaged;
    }

    public void isBatch(Boolean isBatch) {
        this.isBatch = isBatch;
    }

    public void isPaged(Boolean isPaged) {
        this.isPaged = isPaged;
    }

    @Override
    public boolean hasMetaData() {
        for (Variable var : parameters()) {
            if(var.isMetaDataKey()){
                return true;
            }
        }
        return false;
    }


}
