/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.jdbc;

import java.sql.Connection;
import java.util.Queue;
import org.rapidoid.activity.AbstractLoopThread;
import org.rapidoid.jdbc.JdbcClient;
import org.rapidoid.lambda.Operation;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class JdbcWorker
extends AbstractLoopThread {
    private final JdbcClient jdbc;
    private final Queue<Operation<Connection>> queue;
    private final long batchTimeMs;

    public JdbcWorker(JdbcClient jdbc, Queue<Operation<Connection>> queue, long batchTimeMs) {
        super(0L);
        this.jdbc = jdbc;
        this.queue = queue;
        this.batchTimeMs = batchTimeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loop() throws Exception {
        try (Connection conn = null;){
            long since = 0L;
            do {
                Operation<Connection> op;
                if ((op = this.queue.poll()) == null) {
                    U.sleep((long)1L);
                    break;
                }
                if (conn == null) {
                    conn = this.jdbc.getConnection();
                    since = U.time();
                }
                op.execute((Object)conn);
            } while (Msc.timedOut((long)since, (long)this.batchTimeMs));
        }
    }
}

