package org.refcodes.io;

import java.util.List;

import org.refcodes.component.OpenException;

/**
 * The Class ByteArrayReceiverImpl.
 */
public class ByteArrayReceiverImpl extends AbstractByteReceiver implements ByteArrayReceiver {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new byte array receiver impl.
	 *
	 * @param aDatagrams the datagrams
	 */
	public ByteArrayReceiverImpl( byte[] aDatagrams ) {
		super( aDatagrams.length );
		try {
			open();
			pushDatagrams( aDatagrams );
		}
		catch ( OpenException ignore ) {}
	}

	/**
	 * Instantiates a new byte array receiver impl.
	 *
	 * @param aDatagrams the datagrams
	 */
	public ByteArrayReceiverImpl( List<Byte> aDatagrams ) {
		this( toPrimitiveType( aDatagrams.toArray( new Byte[aDatagrams.size()] ) ) );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public byte[] getBytes() {
		return toPrimitiveType( _datagramQueue.toArray( new Byte[_datagramQueue.size()] ) );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	private static byte[] toPrimitiveType( Byte[] aBytes ) {
		if ( aBytes == null ) return null;
		byte[] thePrimitives = new byte[aBytes.length];
		for ( int i = 0; i < aBytes.length; i++ ) {
			thePrimitives[i] = aBytes[i].byteValue();
		}
		return thePrimitives;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
