// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import org.refcodes.component.Closable;
import org.refcodes.component.CloseException;
import org.refcodes.component.Flushable;
import org.refcodes.component.OpenException;

/**
 * The {@link ByteSenderDecorator} decorates a {@link ByteConsumer} with the
 * additional methods of a {@link ByteSender} making it easy to use a
 * {@link ByteConsumer} wherever a {@link ByteSender} is expected.
 */
public class ByteSenderDecorator extends AbstractByteSender implements ByteSender {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private ByteConsumer _byteConsumer;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new byte sender decorator.
	 *
	 * @param aByteConsumer the byte consumer
	 */
	public ByteSenderDecorator( ByteConsumer aByteConsumer ) {
		_byteConsumer = aByteConsumer;
		try {
			open();
		}
		catch ( OpenException ignore ) {}
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void writeDatagram( byte aDatagram ) throws OpenException {
		_byteConsumer.writeDatagram( aDatagram );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void writeDatagrams( byte[] aDatagrams ) throws OpenException {
		_byteConsumer.writeDatagrams( aDatagrams );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void writeDatagrams( byte[] aDatagrams, int aOffset, int aLength ) throws OpenException {
		_byteConsumer.writeDatagrams( aDatagrams, aOffset, aLength );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void flush() throws OpenException {
		if ( _byteConsumer instanceof Flushable ) {
			((Flushable) _byteConsumer).flush();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void close() throws CloseException {
		if ( _byteConsumer instanceof Closable ) {
			((Closable) _byteConsumer).close();
		}
		super.close();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
