// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import java.io.InputStream;

/**
 * Provides an accessor for a Input-Stream property.
 */
public interface InputStreamAccessor {

	/**
	 * Retrieves the {@link InputStream} from the Input-Stream property.
	 * 
	 * @return The {@link InputStream} stored by the Input-Stream property.
	 */
	InputStream getInputStream();

	/**
	 * Provides a mutator for a Input-Stream property.
	 */
	public interface InputStreamMutator {

		/**
		 * Sets the {@link InputStream} for the Input-Stream property.
		 * 
		 * @param aInputStream The {@link InputStream} to be stored by the
		 *        Input-Stream property.
		 */
		void setInputStream( InputStream aInputStream );
	}

	/**
	 * Provides a builder method for a Input-Stream property returning the
	 * builder for applying multiple build operations.
	 * 
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface InputStreamBuilder<B extends InputStreamBuilder<B>> {

		/**
		 * Sets the {@link InputStream} for the Input-Stream property.
		 * 
		 * @param aInputStream The {@link InputStream} to be stored by the
		 *        Input-Stream property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withInputStream( InputStream aInputStream );
	}

	/**
	 * Provides a Input-Stream property.
	 */
	public interface InputStreamProperty extends InputStreamAccessor, InputStreamMutator {}
}
