// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import java.io.Serializable;

import org.refcodes.component.OpenException;

/**
 * A {@link LoopbackTransceiver} is a {@link DatagramTransceiver} connected
 * directly within the same JVM with another {@link LoopbackTransceiver}; a
 * "loopback" connection is used for establishing the connection which cannot be
 * accessed outside the JVM or the running machine.
 *
 * @param <DATA> The type of the datagram to be operated with.
 */
public interface LoopbackTransceiver<DATA extends Serializable> extends ConnectionTransceiver<DATA, LoopbackTransceiver<DATA>> {

	/**
	 * Pushes a datagram into the {@link LoopbackReceiver}. Them datagrams can
	 * be retrieved via {@link #readDatagram()}: use {@link #hasDatagram()} to
	 * test beforehand whether there is a datagram available.
	 *
	 * @param aDatagram The datagram to be pushed into the
	 *        {@link LoopbackReceiver}; to be retrieved with the
	 *        {@link #readDatagram()} method.
	 * @throws OpenException the open exception
	 */
	void pushDatagram( DATA aDatagram ) throws OpenException;
}
