// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.io;

import org.refcodes.component.ConnectableComponent.ConnectableAutomaton;
import org.refcodes.component.OpenException;
import org.refcodes.mixin.Releaseable;

/**
 * The Interface Receivable.
 */
public interface Receivable extends ConnectableAutomaton, Releaseable {

	/**
	 * Determines whether a datagram is available from a {@link DatagramSender}.
	 * 
	 * Use the {@link DatagramProvider} extenison's
	 * {@link DatagramProvider#readDatagram()} method for retrieving the
	 * available datagram.
	 * 
	 * @return True in case there is a datagram ready to be retrieved .
	 * 
	 * @throws OpenException Thrown in case opening or accessing an open line
	 *         (connection, junction, link) caused problems.
	 */
	boolean hasDatagram() throws OpenException;
}
