/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.Serializable;
import org.refcodes.component.Closable;
import org.refcodes.component.CloseException;
import org.refcodes.component.Flushable;
import org.refcodes.component.OpenException;
import org.refcodes.io.AbstractSender;
import org.refcodes.io.Consumer;
import org.refcodes.io.Sender;

public class SenderDecorator<DATA extends Serializable>
extends AbstractSender<DATA>
implements Sender<DATA> {
    private Consumer<DATA> _consumer;

    public SenderDecorator(Consumer<DATA> aConsumer) {
        this._consumer = aConsumer;
        try {
            this.open();
        }
        catch (OpenException openException) {
            // empty catch block
        }
    }

    @Override
    public void writeDatagram(DATA aDatagram) throws OpenException {
        this._consumer.writeDatagram(aDatagram);
    }

    @Override
    public void writeDatagrams(DATA[] aDatagrams) throws OpenException {
        this._consumer.writeDatagrams((Serializable[])aDatagrams);
    }

    @Override
    public void writeDatagrams(DATA[] aDatagrams, int aOffset, int aLength) throws OpenException {
        this._consumer.writeDatagrams((Serializable[])aDatagrams, aOffset, aLength);
    }

    @Override
    public void flush() throws OpenException {
        if (this._consumer instanceof Flushable) {
            ((Flushable)this._consumer).flush();
        }
    }

    public void close() throws CloseException {
        if (this._consumer instanceof Closable) {
            ((Closable)this._consumer).close();
        }
        super.close();
    }
}

