/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.core.Ordered;

public final class LazyInitializationBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (String name : beanFactory.getBeanDefinitionNames()) {
            Boolean lazyInit;
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(name);
            if (beanDefinition instanceof AbstractBeanDefinition && (lazyInit = ((AbstractBeanDefinition)beanDefinition).getLazyInit()) != null && !lazyInit.booleanValue()) continue;
            beanDefinition.setLazyInit(true);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

